/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
public class EarPersistenceArchivist
extends PersistenceArchivist {
    public boolean supportsModuleType(XModuleType moduleType) {
        return XModuleType.EAR == moduleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object open(Archivist main, ReadableArchive earArchive, final RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, "EarArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", earArchive.getURI());
        }
        Map<Object, Object> probablePersitenceArchives = new HashMap();
        try {
            PersistenceArchivist.SubArchivePURootScanner earRootScanner = new PersistenceArchivist.SubArchivePURootScanner(){

                @Override
                public String getPathOfSubArchiveToScan() {
                    return "";
                }

                @Override
                public boolean isProbablePuRootJar(String jarName) {
                    return super.isProbablePuRootJar(jarName) && !this.isComponentJar(jarName, ((Application)descriptor).getModules());
                }

                private boolean isComponentJar(String jarName, Set<ModuleDescriptor<BundleDescriptor>> moduleDescriptors) {
                    boolean isComponentJar = false;
                    for (ModuleDescriptor<BundleDescriptor> md : moduleDescriptors) {
                        String archiveUri = md.getArchiveUri();
                        if (!jarName.equals(archiveUri)) continue;
                        isComponentJar = true;
                        break;
                    }
                    return isComponentJar;
                }
            };
            probablePersitenceArchives = this.getProbablePersistenceRoots(earArchive, earRootScanner);
            PersistenceArchivist.SubArchivePURootScanner subArchivePURootScanner = new PersistenceArchivist.SubArchivePURootScanner(){

                String getPathOfSubArchiveToScan() {
                    return "lib";
                }
            };
            probablePersitenceArchives.putAll(this.getProbablePersistenceRoots(earArchive, subArchivePURootScanner));
            for (Map.Entry<Object, Object> pathToArchiveEntry : probablePersitenceArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor(main, (ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (ReadableArchive readableArchive : probablePersitenceArchives.values()) {
                readableArchive.close();
            }
        }
        return null;
    }
}

