/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.login.Configuration;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class SecurityConfigListener
implements ConfigListener,
PostConstruct {
    @Inject
    SecurityService securityService;
    @Inject
    private Logger logger;
    @Inject
    private Habitat habitat;
    @Inject
    private AuthRealm[] realms;
    @Inject
    private JaccProvider[] jaccProvider;
    @Inject
    private AuditModule[] auditModules;
    @Inject
    private MessageSecurityConfig[] messageSecConfigs;
    private String defaultP2R = null;
    private String anonRole = null;
    private String auditEnabled = null;
    private String auditModulesAttr = null;
    private String defaultRealm = null;
    private String jaccAttr = null;

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                NotProcessed np = null;
                switch (type) {
                    case ADD: {
                        SecurityConfigListener.this.logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        SecurityConfigListener.this.logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        SecurityConfigListener.this.logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        np = this.handleRemoveEvent(changedInstance);
                    }
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
                NotProcessed np = null;
                if (instance instanceof AuthRealm) {
                    SecurityConfigListener.this.authRealmCreated((AuthRealm)instance);
                } else if (instance instanceof JaccProvider) {
                    np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                } else if (instance instanceof AuditModule) {
                    SecurityConfigListener.this.auditModuleCreated((AuditModule)instance);
                } else if (!(instance instanceof MessageSecurityConfig) && !(instance instanceof SecurityService)) {
                    np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
                NotProcessed np = null;
                if (instance instanceof AuthRealm) {
                    SecurityConfigListener.this.authRealmDeleted((AuthRealm)instance);
                } else if (instance instanceof JaccProvider) {
                    np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                } else if (instance instanceof AuditModule) {
                    SecurityConfigListener.this.auditModuleDeleted((AuditModule)instance);
                } else if (!(instance instanceof MessageSecurityConfig) && !(instance instanceof SecurityService)) {
                    np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
                NotProcessed np = null;
                if (instance instanceof AuthRealm) {
                    SecurityConfigListener.this.authRealmUpdated((AuthRealm)instance);
                } else if (instance instanceof JaccProvider) {
                    np = new NotProcessed("Cannot change JACC provider once installed, restart required");
                } else if (instance instanceof AuditModule) {
                    SecurityConfigListener.this.auditModuleUpdated((AuditModule)instance);
                } else if (!(instance instanceof MessageSecurityConfig)) {
                    if (instance instanceof SecurityService) {
                        if (SecurityConfigListener.this.defaultRealm != null && !SecurityConfigListener.this.defaultRealm.equals(((SecurityService)instance).getDefaultRealm())) {
                            SecurityConfigListener.this.defaultRealm = ((SecurityService)instance).getDefaultRealm();
                            Realm.setDefaultRealm(SecurityConfigListener.this.defaultRealm);
                        }
                        if (SecurityConfigListener.this.auditEnabled != null && !SecurityConfigListener.this.auditEnabled.equals(((SecurityService)instance).getAuditEnabled())) {
                            AuditManager manager = SecurityServicesUtil.getInstance().getAuditManager();
                            boolean auditON = Boolean.parseBoolean(((SecurityService)instance).getAuditEnabled());
                            manager.setAuditOn(auditON);
                        }
                    } else {
                        np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
                    }
                }
                return np;
            }
        }, (Logger)this.logger);
        return null;
    }

    public void authRealmCreated(AuthRealm instance) {
        try {
            this.createRealm(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void authRealmDeleted(AuthRealm instance) {
        try {
            Realm.unloadInstance(instance.getName());
        }
        catch (NoSuchRealmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void authRealmUpdated(AuthRealm instance) {
        try {
            this.createRealm(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void createRealm(AuthRealm authRealm) throws Exception {
        String className = authRealm.getClassname();
        List elementProps = authRealm.getProperty();
        Properties props = new Properties();
        if (elementProps != null) {
            for (Property p : elementProps) {
                props.setProperty(p.getName(), p.getValue());
            }
        }
        if ("com.sun.enterprise.security.auth.realm.file.FileRealm".equals(className)) {
            SecuritySupport secSupp = (SecuritySupport)Globals.getDefaultHabitat().getByContract(SecuritySupport.class);
            secSupp.synchronizeKeyFile(null, authRealm.getName());
        }
        Realm.instantiate(authRealm.getName(), className, props);
        Configuration.getConfiguration().refresh();
    }

    public void postConstruct() {
        if (this.securityService == null) {
            return;
        }
        this.defaultP2R = this.securityService.getActivateDefaultPrincipalToRoleMapping();
        this.anonRole = this.securityService.getAnonymousRole();
        this.jaccAttr = this.securityService.getJacc();
        this.auditEnabled = this.securityService.getAuditEnabled();
        this.auditModulesAttr = this.securityService.getAuditModules();
        this.defaultRealm = this.securityService.getDefaultRealm();
    }

    public void auditModuleCreated(AuditModule instance) {
        try {
            String classname = instance.getClassname();
            List props = instance.getProperty();
            Properties properties = new Properties();
            if (props != null) {
                for (Property p : props) {
                    properties.put(p.getName(), p.getValue());
                }
            }
            AuditManager manager = SecurityServicesUtil.getInstance().getAuditManager();
            manager.addAuditModule(instance.getName(), classname, properties);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void auditModuleDeleted(AuditModule instance) {
        AuditManager manager = SecurityServicesUtil.getInstance().getAuditManager();
        manager.removeAuditModule(instance.getName());
    }

    public void auditModuleUpdated(AuditModule instance) {
        try {
            List props = instance.getProperty();
            Properties properties = new Properties();
            if (props != null) {
                for (Property p : props) {
                    properties.put(p.getName(), p.getValue());
                }
            }
            AuditManager manager = SecurityServicesUtil.getInstance().getAuditManager();
            manager.addAuditModule(instance.getName(), instance.getClassname(), properties);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

