/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="JRuby runtime pool stats")
public class JRubyRuntimePool {
    private final AtomicInteger hardMinimum = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger hardMaximum = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger activeRuntimes = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger queueSize = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger queueUpThreshold = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger queueDownThreshold = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger newThreshold = new AtomicInteger(Integer.MIN_VALUE);

    private JRubyRuntimePool(Builder builder) {
        this.hardMinimum.set(builder.hardMinimum);
        this.hardMaximum.set(builder.hardMaximum);
        this.activeRuntimes.set(builder.activeRuntimes);
        this.queueSize.set(builder.queueSize);
        this.queueUpThreshold.set(builder.queueUpThreshold);
        this.queueDownThreshold.set(builder.queueDownThreshold);
        this.newThreshold.set(builder.newThreshold);
    }

    @ManagedAttribute
    @Description(value="Minimum runtimes active")
    public int getHardMinimum() {
        return this.hardMinimum.get();
    }

    @ManagedAttribute
    @Description(value="Maximum runtimes active")
    public int getHardMaximum() {
        return this.hardMaximum.get();
    }

    @ManagedAttribute
    @Description(value="Currently active runtimes")
    public int getActiveRuntimes() {
        return this.activeRuntimes.get();
    }

    @ManagedAttribute
    @Description(value="Maximum idle runtimes")
    public int getQueueSize() {
        return this.queueSize.get();
    }

    @ManagedAttribute
    @Description(value="How eager the pool is to increase the maximum idle runtimes")
    public int getQueueUpThreshold() {
        return this.queueUpThreshold.get();
    }

    @ManagedAttribute
    @Description(value="How eager the pool is to decrease the currently active runtimes")
    public int getQueueDownThreshold() {
        return this.queueDownThreshold.get();
    }

    @ManagedAttribute
    @Description(value="How eager the pool is to increase the currently active runtimes")
    public int getNewThreshold() {
        return this.newThreshold.get();
    }

    void update(Builder builder) {
        this.activeRuntimes.set(builder.activeRuntimes);
        this.queueSize.set(builder.queueSize);
        this.queueUpThreshold.set(builder.queueUpThreshold);
        this.queueDownThreshold.set(builder.queueDownThreshold);
        this.newThreshold.set(builder.newThreshold);
    }

    public static class Builder {
        private int hardMinimum;
        private int hardMaximum;
        private int activeRuntimes;
        private int queueSize;
        private int queueUpThreshold;
        private int queueDownThreshold;
        private int newThreshold;

        public Builder(int hardMinimum, int hardMaximum) {
            this.hardMinimum = hardMinimum;
            this.hardMaximum = hardMaximum;
        }

        public Builder activeRuntimes(int value) {
            this.activeRuntimes = value;
            return this;
        }

        public Builder queueSize(int value) {
            this.queueSize = value;
            return this;
        }

        public Builder queueUpThreshold(int value) {
            this.queueUpThreshold = value;
            return this;
        }

        public Builder queueDownThreshold(int value) {
            this.queueDownThreshold = value;
            return this;
        }

        public Builder newThreshold(int value) {
            this.newThreshold = value;
            return this;
        }

        public JRubyRuntimePool build() {
            return new JRubyRuntimePool(this);
        }
    }
}

