/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.GrizzlyContext;
import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.RackAdapter;
import com.sun.grizzly.jruby.rack.RackApplication;
import com.sun.grizzly.jruby.rack.RackApplicationFactory;
import com.sun.grizzly.jruby.rack.RackInitializationException;
import com.sun.grizzly.jruby.rack.RubyRuntimeFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class MultiThreadedRackAdapter
implements RackAdapter {
    private RackApplication theApp;
    private final RackApplicationFactory myFactory;
    private final RackGrizzlyAdapter adapter;

    public MultiThreadedRackAdapter(RackApplicationFactory f, RackGrizzlyAdapter adapter) {
        this.myFactory = f;
        this.adapter = adapter;
        RubyRuntimeFactory rubyfactory = new RubyRuntimeFactory();
        Ruby runtime = rubyfactory.makeRubyRuntime(adapter.config.jrubyHome());
        GrizzlyContext context = new GrizzlyContext(adapter);
        runtime.defineReadonlyVariable("$grizzly_context", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)context));
        IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)context.getLogger());
        runtime.defineReadonlyVariable("$logger", loggerObj);
        String log_level = this.getEffectiveLogLevel();
        IRubyObject GF_log_level = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)log_level);
        runtime.defineReadonlyVariable("$glassfish_log_level", GF_log_level);
        runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)adapter.config.contextRoot()));
        try {
            this.theApp = this.myFactory.newApplication(runtime);
        }
        catch (RackInitializationException e) {
            adapter.getLogger().log(Level.SEVERE, e.getMessage(), e);
            this.theApp = this.myFactory.getErrorApplication(runtime);
        }
    }

    private String getEffectiveLogLevel() {
        Logger pLog = this.adapter.getLogger();
        Level myLevel = pLog.getLevel();
        while (myLevel == null) {
            pLog = pLog.getParent();
            myLevel = pLog.getLevel();
        }
        return myLevel.getName();
    }

    public void shutdown() {
        this.theApp.getRuntime().tearDown();
    }

    public RackApplication getApp() {
        return this.theApp;
    }

    public void returnApp(RackApplication returned) {
    }

    public RackApplicationFactory getFactory() {
        return this.myFactory;
    }
}

