/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.ConnectorSecurityMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-connector-security-map")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.security.map")
public class CreateConnectorSecurityMap
extends ConnectorSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateConnectorSecurityMap.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="poolname")
    String poolName;
    @Param(name="principals", optional=true)
    List<String> principals;
    @Param(name="usergroups", optional=true)
    List<String> userGroups;
    @Param(name="mappedusername")
    String mappedusername;
    @Param(name="mappedpassword", optional=true)
    String mappedpassword;
    @Param(name="mapname", primary=true)
    String securityMapName;
    @Inject
    ConnectorConnectionPool[] ccPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.securityMapName == null) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.noSecurityMapName", "No security map name specified"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.principals == null && this.userGroups == null) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.noPrincipalsOrGroupsMap", "Either the principal or the user group has to be specified while creating a security map. Both cannot be null."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.principals != null && this.userGroups != null) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.specifyPrincipalsOrGroupsMap", "A work-security-map can have either (any number of) group mapping or (any number of) principals mapping but not both. Specify --principalsmap or --groupsmap."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.doesPoolNameExist(this.poolName, this.ccPools)) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.noSuchPoolFound", "Connector connection pool {0} does not exist. Please specify a valid pool name.", new Object[]{this.poolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.doesMapNameExist(this.poolName, this.securityMapName, this.ccPools)) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.duplicate", "A security map named {0} already exists for connector connection pool {1}. Please give a different map name.", new Object[]{this.securityMapName, this.poolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List<SecurityMap> maps = this.getAllSecurityMapsForPool(this.poolName, this.ccPools);
        if (this.principals != null) {
            for (String principal : this.principals) {
                if (!this.isPrincipalExisting(principal, maps)) continue;
                report.setMessage(localStrings.getLocalString("create.connector.security.map.principal_exists", "The principal {0} already exists in connector connection pool {1}. Please give a different principal name.", new Object[]{principal, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.userGroups != null) {
            for (String userGroup : this.userGroups) {
                if (!this.isUserGroupExisting(userGroup, maps)) continue;
                report.setMessage(localStrings.getLocalString("create.connector.security.map.usergroup_exists", "The user-group {0} already exists in connector connection pool {1}. Please give a different user-group name.", new Object[]{userGroup, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        ConnectorConnectionPool connPool = null;
        for (ConnectorConnectionPool ccp : this.ccPools) {
            if (!ccp.getName().equals(this.poolName)) continue;
            connPool = ccp;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConnectorConnectionPool>(){

                public Object run(ConnectorConnectionPool ccp) throws PropertyVetoException, TransactionFailure {
                    List securityMaps = ccp.getSecurityMap();
                    SecurityMap newResource = (SecurityMap)ccp.createChild(SecurityMap.class);
                    newResource.setName(CreateConnectorSecurityMap.this.securityMapName);
                    if (CreateConnectorSecurityMap.this.principals != null) {
                        for (String p : CreateConnectorSecurityMap.this.principals) {
                            newResource.getPrincipal().add(p);
                        }
                    }
                    if (CreateConnectorSecurityMap.this.userGroups != null) {
                        for (String u : CreateConnectorSecurityMap.this.userGroups) {
                            newResource.getUserGroup().add(u);
                        }
                    }
                    BackendPrincipal backendPrincipal = (BackendPrincipal)newResource.createChild(BackendPrincipal.class);
                    backendPrincipal.setUserName(CreateConnectorSecurityMap.this.mappedusername);
                    if (CreateConnectorSecurityMap.this.mappedpassword != null && !CreateConnectorSecurityMap.this.mappedpassword.isEmpty()) {
                        backendPrincipal.setPassword(CreateConnectorSecurityMap.this.mappedpassword);
                    }
                    newResource.setBackendPrincipal(backendPrincipal);
                    securityMaps.add(newResource);
                    return newResource;
                }
            }, connPool);
        }
        catch (TransactionFailure tfe) {
            Object[] params = new Object[]{this.securityMapName, this.poolName};
            report.setMessage(localStrings.getLocalString("create.connector.security.map.fail", "Unable to create connector security map {0} for connector connection pool {1} ", params) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

