/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;

class SetRoleConstantAction
implements ConstantAction {
    private final String roleName;
    private final int type;

    SetRoleConstantAction(String string, int n) {
        this.roleName = string;
        this.type = n;
    }

    public String toString() {
        return "SET ROLE " + (this.type == 1 && this.roleName == null ? "?" : this.roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = this.roleName;
        String string2 = languageConnectionContext.getAuthorizationId();
        String string3 = languageConnectionContext.getDataDictionary().getAuthorizationDatabaseOwner();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        if (!transactionController.isIdle()) {
            throw StandardException.newException("25001.S.1");
        }
        if (this.type == 1) {
            object = activation.getParameterValueSet();
            DataValueDescriptor dataValueDescriptor = object.getParameter(0);
            string = dataValueDescriptor.getString();
        }
        object = null;
        if (string != null) {
            try {
                object = dataDictionary.getRoleDefinitionDescriptor(string);
                if (object == null) {
                    throw StandardException.newException("0P000", string);
                }
                if (!string2.equals(string3) && (object = dataDictionary.getRoleGrantDescriptor(string, string2, string3)) == null && (object = dataDictionary.getRoleGrantDescriptor(string, "PUBLIC", string3)) == null) {
                    throw StandardException.newException("0P000.S.1", string);
                }
            }
            finally {
                languageConnectionContext.userCommit();
            }
        }
        languageConnectionContext.setCurrentRole(activation, object != null ? string : null);
    }
}

