/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.slave;

import java.util.NoSuchElementException;
import org.apache.derby.iapi.error.StandardException;

class ReplicationLogScan {
    private byte[] logToScan;
    private int currentPosition;
    private long currentInstant;
    private int currentDataOffset;
    private byte[] currentData;
    private boolean hasInfo;
    private boolean isLogSwitch;

    protected ReplicationLogScan() {
    }

    protected void init(byte[] byArray) {
        this.logToScan = byArray;
        this.currentPosition = 0;
        this.currentInstant = -1L;
        this.currentData = null;
        this.isLogSwitch = false;
        this.hasInfo = false;
    }

    protected boolean next() throws StandardException {
        if (this.currentPosition == this.logToScan.length) {
            this.hasInfo = false;
            return this.hasInfo;
        }
        try {
            int n = this.retrieveInt();
            if (n == 0) {
                this.isLogSwitch = true;
                this.hasInfo = true;
            } else {
                this.currentInstant = this.retrieveLong();
                this.currentData = new byte[n];
                this.retrieveBytes(this.currentData, n);
                this.retrieveInt();
                this.isLogSwitch = false;
                this.hasInfo = true;
            }
        }
        catch (StandardException standardException) {
            this.hasInfo = false;
            throw standardException;
        }
        return this.hasInfo;
    }

    protected long getInstant() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        if (this.isLogSwitch) {
            return -1L;
        }
        return this.currentInstant;
    }

    protected int getDataLength() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        if (this.isLogSwitch) {
            return -1;
        }
        return this.currentData.length;
    }

    protected byte[] getData() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        if (this.isLogSwitch) {
            return null;
        }
        return this.currentData;
    }

    protected boolean hasValidInformation() {
        return this.hasInfo;
    }

    protected boolean isLogRecord() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        return !this.isLogSwitch;
    }

    protected boolean isLogFileSwitch() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        return this.isLogSwitch;
    }

    private void retrieveBytes(byte[] byArray, int n) throws StandardException {
        try {
            System.arraycopy(this.logToScan, this.currentPosition, byArray, 0, n);
            this.currentPosition += n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw StandardException.newException("XRE01", arrayIndexOutOfBoundsException);
        }
    }

    private int retrieveInt() throws StandardException {
        try {
            int n = (this.logToScan[this.currentPosition++] << 24) + ((this.logToScan[this.currentPosition++] & 0xFF) << 16) + ((this.logToScan[this.currentPosition++] & 0xFF) << 8) + (this.logToScan[this.currentPosition++] & 0xFF);
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw StandardException.newException("XRE01", arrayIndexOutOfBoundsException);
        }
    }

    private long retrieveLong() throws StandardException {
        try {
            long l = ((long)this.logToScan[this.currentPosition++] << 56) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 48) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 40) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 32) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 24) + (long)((this.logToScan[this.currentPosition++] & 0xFF) << 16) + (long)((this.logToScan[this.currentPosition++] & 0xFF) << 8) + (long)(this.logToScan[this.currentPosition++] & 0xFF);
            return l;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw StandardException.newException("XRE01", arrayIndexOutOfBoundsException);
        }
    }
}

