/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.scripting.jruby.monitor.RubyApplicationInfo;

@AMXMetadata(type="jruby-container-mon", group="monitoring")
@ManagedObject
@Description(value="JRuby Container Statistics")
public class JRubyProbeStatsProvider {
    private final CountStatisticImpl activeRubyAppsCount = new CountStatisticImpl("ActiveRubyApplications", "count", "Number of currently loaded Ruby applications");
    private final ConcurrentHashMap<String, RubyApplicationInfo> apps = new ConcurrentHashMap();
    private final Logger logger = Logger.getLogger(JRubyProbeStatsProvider.class.getName());

    public JRubyProbeStatsProvider() {
        this.logger.fine("JRubyProbeStatsProvider() created");
    }

    @ProbeListener(value="glassfish:jruby:jruby-container:jrubyModuleStartedEvent")
    public void jrubyModuleStartedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="applicationType") String applicationType, @ProbeParam(value="environment") String environment, @ProbeParam(value="jrubyVersion") String jrubyVersion) {
        if (appName == null) {
            this.logger.warning("appName is null in jrubyModuleStartedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.logger.fine("JRubyProbeStatsProvider:jrubyModuleStartedEvent invoked");
        this.activeRubyAppsCount.increment();
        this.logger.info("Application name" + appName + ", appType: " + applicationType + ", environment: " + environment + ", jrubyVersion: " + jrubyVersion);
        this.apps.put(appName, new RubyApplicationInfo(appName, applicationType, environment, jrubyVersion));
        this.logger.info("apps size:" + this.apps.size());
    }

    @ProbeListener(value="glassfish:jruby:jruby-container:jrubyModuleStoppedEvent")
    public void jrubyModuleStoppedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="applicationType") String applicationType, @ProbeParam(value="environment") String environment) {
        if (appName == null) {
            this.logger.warning("appName is null in jrubyModuleStoppedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.logger.fine("JRubyProbeStatsProvider:jrubyModuleStoppedEvent invoked");
        this.activeRubyAppsCount.decrement();
        this.apps.remove(appName);
    }

    @ManagedAttribute(id="activerubyappscount")
    @Description(value="Number of active Ruby applications")
    public CountStatistic getActiveRubyAppsCount() {
        return this.activeRubyAppsCount;
    }

    @ManagedAttribute(id="activerubyapplications")
    @Description(value="Active Ruby applications")
    public RubyApplicationInfoStats getActiveRubyApplications() {
        return new RubyApplicationInfoStats(this.apps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ManagedData
    private static class RubyApplicationInfoStats
    implements Stats {
        private final Map<String, RubyApplicationInfo> map = new HashMap<String, RubyApplicationInfo>();
        private final RubyApplicationInfo[] info;

        private RubyApplicationInfoStats(Map<String, RubyApplicationInfo> currAppInfo) {
            this.map.putAll(currAppInfo);
            this.info = this.map.values().toArray(new RubyApplicationInfo[this.map.size()]);
        }

        public Statistic getStatistic(String s) {
            return (Statistic)this.map.get(s);
        }

        public String[] getStatisticNames() {
            Set<String> names = this.map.keySet();
            return names.toArray(new String[names.size()]);
        }

        @ManagedAttribute
        public RubyApplicationInfo[] getStatistics() {
            return this.info;
        }
    }
}

