/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.web.plugin.common.WebModuleConfig;
import org.jvnet.hk2.annotations.Inject;

public abstract class WebModuleConfigCommand
implements AdminCommand {
    private static final String WEB_SNIFFER_TYPE = "web";
    @Param(primary=true)
    private String appNameAndOptionalModuleName;
    @Inject
    private Applications apps;
    protected final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebModuleConfigCommand.class);

    protected WebModuleConfig webModuleConfig(ActionReport report) {
        Module m = this.module(report);
        if (m == null) {
            return null;
        }
        WebModuleConfig config = (WebModuleConfig)this.engine(report).getApplicationConfig();
        return config;
    }

    private Application application() {
        Application result = (Application)this.apps.getModule(Application.class, this.appName());
        return result;
    }

    private Module module(ActionReport report) {
        Application app = this.application();
        if (app == null) {
            this.fail(report, "appNotReg", "Application {0} not registered", this.appName());
            return null;
        }
        Module module = app.getModule(this.moduleName());
        if (module == null) {
            this.fail(report, "noSuchModule", "Application {0} does not contain module {1}", this.appName(), this.moduleName());
        }
        return module;
    }

    protected Engine engine(ActionReport report) {
        Module module = this.module(report);
        if (module == null) {
            return null;
        }
        Engine e = module.getEngine(WEB_SNIFFER_TYPE);
        if (e == null) {
            this.fail(report, "noSuchEngine", "Application {0}/module {1} does not contain engine {2}", this.appName(), this.moduleName(), WEB_SNIFFER_TYPE);
        }
        return e;
    }

    protected String moduleName() {
        int endOfAppName = this.endOfAppName();
        return endOfAppName == this.appNameAndOptionalModuleName.length() ? this.appNameAndOptionalModuleName : this.appNameAndOptionalModuleName.substring(endOfAppName);
    }

    protected String appName() {
        return this.appNameAndOptionalModuleName.substring(0, this.endOfAppName());
    }

    private int endOfAppName() {
        int slash = this.appNameAndOptionalModuleName.indexOf(47);
        return slash == -1 ? this.appNameAndOptionalModuleName.length() : slash;
    }

    protected ActionReport fail(ActionReport report, Exception e, String msgKey, String defaultFormat, Object ... args) {
        report.setFailureCause((Throwable)e);
        return this.fail(report, msgKey, defaultFormat, args);
    }

    protected ActionReport fail(ActionReport report, String msgKey, String defaultFormat, Object ... args) {
        return this.finish(report, ActionReport.ExitCode.FAILURE, msgKey, defaultFormat, args);
    }

    protected ActionReport succeed(ActionReport report, String msgKey, String defaultFormat, Object ... args) {
        return this.finish(report, ActionReport.ExitCode.SUCCESS, msgKey, defaultFormat, args);
    }

    private ActionReport finish(ActionReport report, ActionReport.ExitCode exitCode, String msgKey, String defaultFormat, Object ... args) {
        String msg = this.localStrings.getLocalString(msgKey, defaultFormat, args);
        report.setActionDescription(msg);
        report.setActionExitCode(exitCode);
        return report;
    }
}

