/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.visitors;

import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVisitor<R, P>
extends SimpleTypeVisitor6<MetadataAnnotatedElement, MetadataAnnotatedElement> {
    public static String GENERIC_TYPE = "? extends Object";
    private StringTypeVisitor<String, Object> stringTypeVisitor = new StringTypeVisitor();

    private String getRawClass(String type) {
        if (type.indexOf("<") > -1) {
            return type.substring(0, type.indexOf("<"));
        }
        return type;
    }

    @Override
    public MetadataAnnotatedElement visitArray(ArrayType arrayType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(arrayType.accept(this.stringTypeVisitor, null));
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitDeclared(DeclaredType declaredType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(this.getRawClass(declaredType.accept(this.stringTypeVisitor, null)));
        annotatedElement.addGenericType(annotatedElement.getType());
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            annotatedElement.addGenericType(typeMirror.accept(this.stringTypeVisitor, null));
        }
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitError(ErrorType errorType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(errorType.accept(this.stringTypeVisitor, null));
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitExecutable(ExecutableType executableType, MetadataAnnotatedElement annotatedElement) {
        MetadataMethod method = (MetadataMethod)annotatedElement;
        for (TypeMirror typeMirror : executableType.getParameterTypes()) {
            method.addParameter(this.getRawClass(typeMirror.accept(this.stringTypeVisitor, null)));
        }
        executableType.getReturnType().accept(this, method);
        method.setReturnType(method.getType());
        return method;
    }

    @Override
    public MetadataAnnotatedElement visitNoType(NoType noType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(noType.accept(this.stringTypeVisitor, null));
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitNull(NullType nullType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(nullType.accept(this.stringTypeVisitor, null));
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitPrimitive(PrimitiveType primitiveType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setPrimitiveType(primitiveType);
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitTypeVariable(TypeVariable typeVariable, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(typeVariable.accept(this.stringTypeVisitor, null));
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitWildcard(WildcardType wildcardType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(wildcardType.accept(this.stringTypeVisitor, null));
        return annotatedElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StringTypeVisitor<E, A>
    extends SimpleTypeVisitor6<String, Object> {
        @Override
        public String visitArray(ArrayType arrayType, Object obj) {
            return arrayType.toString();
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Object obj) {
            return declaredType.toString();
        }

        @Override
        public String visitError(ErrorType errorType, Object obj) {
            return GENERIC_TYPE;
        }

        @Override
        public String visitExecutable(ExecutableType executableType, Object obj) {
            return executableType.toString();
        }

        @Override
        public String visitNoType(NoType noType, Object obj) {
            return GENERIC_TYPE;
        }

        @Override
        public String visitNull(NullType nullType, Object obj) {
            return GENERIC_TYPE;
        }

        @Override
        public String visitPrimitive(PrimitiveType primitiveType, Object obj) {
            return primitiveType.toString();
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, Object obj) {
            return GENERIC_TYPE;
        }

        @Override
        public String visitWildcard(WildcardType wildcardType, Object obj) {
            return wildcardType.toString();
        }
    }
}

