/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.DisposalMethod;
import org.jboss.webbeans.bean.SessionBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethod<T>
extends AbstractProducerBean<T, Method> {
    private MethodInjectionPoint<T, ?> method;
    private DisposalMethod<?> disposalMethodBean;
    private ProducerMethod<?> specializedBean;
    private final String id;

    public static <T> ProducerMethod<T> of(WBMethod<T, ?> method, AbstractClassBean<?> declaringBean, BeanManagerImpl manager) {
        return new ProducerMethod<T>(method, declaringBean, manager);
    }

    protected ProducerMethod(WBMethod<T, ?> method, AbstractClassBean<?> declaringBean, BeanManagerImpl manager) {
        super(declaringBean, manager);
        this.method = MethodInjectionPoint.of(this, method);
        this.initType();
        this.initTypes();
        this.initBindings();
        this.id = ProducerMethod.createId("ProducerMethod-" + declaringBean.getType().getName() + "-" + method.getSignature().toString());
        this.initStereotypes();
        this.initPolicy();
    }

    @Override
    public T produce(CreationalContext<T> creationalContext) {
        Object receiver = this.getReceiver(creationalContext);
        if (receiver != null) {
            return this.method.invokeOnInstance(receiver, this.manager, creationalContext, CreationException.class);
        }
        return this.method.invoke(receiver, this.manager, creationalContext, CreationException.class);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            this.initProducerMethodInjectableParameters();
            super.initialize(environment);
            this.checkProducerMethod();
            this.initDisposalMethod(environment);
        }
    }

    protected void initProducerMethodInjectableParameters() {
        for (ParameterInjectionPoint<?, ?> parameter : this.method.getWBParameters()) {
            this.addInjectionPoint(ParameterInjectionPoint.of(this, parameter));
        }
    }

    protected void checkProducerMethod() {
        if (this.getAnnotatedItem().getAnnotatedWBParameters(Observes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Observes");
        }
        if (this.getAnnotatedItem().getAnnotatedWBParameters(Disposes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Disposes");
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class)) continue;
                Class clazz = (Class)type;
                try {
                    clazz.getDeclaredMethod(this.getAnnotatedItem().getName(), this.getAnnotatedItem().getParameterTypesAsArray());
                    methodDeclaredOnTypes = true;
                }
                catch (NoSuchMethodException nsme) {}
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException("Producer method " + this.toString() + " must be declared on a business interface of " + this.getDeclaringBean());
            }
        }
    }

    protected void initDisposalMethod(BeanDeployerEnvironment environment) {
        Set<DisposalMethod<?>> disposalBeans = environment.resolveDisposalBeans(this.getTypes(), this.getQualifiers(), this.getDeclaringBean());
        if (disposalBeans.size() == 1) {
            this.disposalMethodBean = disposalBeans.iterator().next();
        } else if (disposalBeans.size() > 1) {
            throw new DefinitionException("Cannot declare multiple disposal methods for this producer method. Producer method: " + this + ". Disposal methods: " + disposalBeans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.dispose(instance);
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    @Override
    public void dispose(T instance) {
        if (this.disposalMethodBean != null) {
            this.disposalMethodBean.invokeDisposeMethod(instance);
        }
    }

    @Override
    public WBMethod<T, ?> getAnnotatedItem() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public DisposalMethod<?> getDisposalMethod() {
        return this.disposalMethodBean;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScope()));
        if (this.getName() == null) {
            buffer.append("unnamed producer method bean");
        } else {
            buffer.append("simple producer method bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getBeanClass().getName() + "] for class type [" + this.getType().getName() + "] API types " + this.getTypes() + ", binding types " + this.getQualifiers());
        return buffer.toString();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.getDeclaringBean().getAnnotatedItem().getWBSuperclass().getDeclaredWBMethod(this.getAnnotatedItem().getAnnotatedMethod()) == null) {
            throw new DefinitionException("Specialized producer method does not override a method on the direct superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        WBMethod<?, ?> superClassMethod = this.getDeclaringBean().getAnnotatedItem().getWBSuperclass().getWBMethod(this.getAnnotatedItem().getAnnotatedMethod());
        if (environment.getProducerMethod(superClassMethod) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        this.specializedBean = environment.getProducerMethod(superClassMethod);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }
}

