/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.builtin.DefaultValidatorBean;
import org.jboss.webbeans.bean.builtin.DefaultValidatorFactoryBean;
import org.jboss.webbeans.bean.builtin.InjectionPointBean;
import org.jboss.webbeans.bean.builtin.ManagerBean;
import org.jboss.webbeans.bean.builtin.PrincipalBean;
import org.jboss.webbeans.bean.builtin.UserTransactionBean;
import org.jboss.webbeans.bean.builtin.facade.EventBean;
import org.jboss.webbeans.bean.builtin.facade.InstanceBean;
import org.jboss.webbeans.bootstrap.BeanDeployer;
import org.jboss.webbeans.bootstrap.api.Environment;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.conversation.JavaSEConversationTerminator;
import org.jboss.webbeans.conversation.NumericConversationIdGenerator;
import org.jboss.webbeans.conversation.ServletConversationManager;
import org.jboss.webbeans.ejb.EjbDescriptors;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.security.spi.SecurityServices;
import org.jboss.webbeans.servlet.HttpSessionManager;
import org.jboss.webbeans.transaction.spi.TransactionServices;
import org.jboss.webbeans.validation.spi.ValidationServices;
import org.jboss.webbeans.xml.BeansXmlParser;

public class BeanDeployment {
    private static final Log log = Logging.getLog(BeanDeployment.class);
    private final BeanDeploymentArchive beanDeploymentArchive;
    private final BeanManagerImpl beanManager;
    private final BeanDeployer beanDeployer;

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this.beanDeploymentArchive = beanDeploymentArchive;
        EjbDescriptors ejbDescriptors = new EjbDescriptors();
        beanDeploymentArchive.getServices().add(EjbDescriptors.class, ejbDescriptors);
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.addAll(deploymentServices.entrySet());
        services.addAll(beanDeploymentArchive.getServices().entrySet());
        this.beanManager = BeanManagerImpl.newManager(deploymentManager, services);
        if (this.beanManager.getServices().contains(EjbServices.class)) {
            ejbDescriptors.addAll(beanDeploymentArchive.getEjbs());
        }
        this.beanDeployer = new BeanDeployer(this.beanManager, deploymentManager, ejbDescriptors);
        this.parseBeansXml();
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public BeanDeployer getBeanDeployer() {
        return this.beanDeployer;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    private void parseBeansXml() {
        BeansXmlParser parser = new BeansXmlParser(this.beanManager.getServices().get(ResourceLoader.class), this.getBeanDeploymentArchive().getBeansXml());
        parser.parse();
        if (parser.getEnabledPolicyClasses() != null) {
            this.beanManager.setEnabledPolicyClasses(parser.getEnabledPolicyClasses());
        }
        if (parser.getEnabledPolicyStereotypes() != null) {
            this.beanManager.setEnabledPolicyStereotypes(parser.getEnabledPolicyStereotypes());
        }
        if (parser.getEnabledDecoratorClasses() != null) {
            this.beanManager.setEnabledDecoratorClasses(parser.getEnabledDecoratorClasses());
        }
        if (parser.getEnabledInterceptorClasses() != null) {
            this.beanManager.setEnabledInterceptorClasses(parser.getEnabledInterceptorClasses());
        }
        log.debug((Object)("Enabled policies for " + this + ": " + this.beanManager.getEnabledPolicyClasses() + " " + this.beanManager.getEnabledPolicyStereotypes()), new Object[0]);
        log.debug((Object)("Enabled decorator types for " + this.beanManager + ": " + this.beanManager.getEnabledDecoratorClasses()), new Object[0]);
        log.debug((Object)("Enabled interceptor types for " + this.beanManager + ": " + this.beanManager.getEnabledInterceptorClasses()), new Object[0]);
    }

    public void deployBeans(Environment environment) {
        this.beanDeployer.addClasses(this.beanDeploymentArchive.getBeanClasses());
        this.beanDeployer.getEnvironment().addBean(new ManagerBean(this.beanManager));
        this.beanDeployer.getEnvironment().addBean(new InjectionPointBean(this.beanManager));
        this.beanDeployer.getEnvironment().addBean(new EventBean(this.beanManager));
        this.beanDeployer.getEnvironment().addBean(new InstanceBean(this.beanManager));
        if (!environment.equals(Environments.SE)) {
            this.beanDeployer.addClass(ConversationImpl.class);
            this.beanDeployer.addClass(ServletConversationManager.class);
            this.beanDeployer.addClass(JavaSEConversationTerminator.class);
            this.beanDeployer.addClass(NumericConversationIdGenerator.class);
            this.beanDeployer.addClass(HttpSessionManager.class);
        }
        if (this.beanManager.getServices().contains(TransactionServices.class)) {
            this.beanDeployer.getEnvironment().addBean(new UserTransactionBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(SecurityServices.class)) {
            this.beanDeployer.getEnvironment().addBean(new PrincipalBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(ValidationServices.class)) {
            this.beanDeployer.getEnvironment().addBean(new DefaultValidatorBean(this.beanManager));
            this.beanDeployer.getEnvironment().addBean(new DefaultValidatorFactoryBean(this.beanManager));
        }
        this.beanDeployer.createBeans().deploy();
    }
}

