/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.Container;
import org.jboss.webbeans.bean.builtin.ExtensionBean;
import org.jboss.webbeans.bootstrap.AbstractBeanDeployer;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.ejb.EjbDescriptors;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionBeanDeployer
extends AbstractBeanDeployer {
    private final Set<Extension> extensions = new HashSet<Extension>();

    public ExtensionBeanDeployer(BeanManagerImpl manager) {
        super(manager, new BeanDeployerEnvironment(new EjbDescriptors(), manager));
    }

    public AbstractBeanDeployer createBeans() {
        ClassTransformer classTransformer = Container.instance().deploymentServices().get(ClassTransformer.class);
        for (Extension extension : this.extensions) {
            WBClass<Extension> clazz = classTransformer.loadClass(extension.getClass());
            ExtensionBean bean = new ExtensionBean(this.getManager(), clazz, extension);
            this.getEnvironment().addBean(bean);
            this.createObserverMethods(bean, clazz);
        }
        return this;
    }

    public void addExtensions(Iterable<Extension> extensions) {
        for (Extension extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }
}

