/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Decorates;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.ForwardingWBField;
import org.jboss.webbeans.introspector.WBField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjectionPoint<T, X>
extends ForwardingWBField<T, X>
implements WBInjectionPoint<T, Field> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final WBField<T, X> field;
    private final boolean delegate;

    public static <T, X> FieldInjectionPoint<T, X> of(Bean<?> declaringBean, WBField<T, X> field) {
        return new FieldInjectionPoint<T, X>(declaringBean, field);
    }

    protected FieldInjectionPoint(Bean<?> declaringBean, WBField<T, X> field) {
        this.declaringBean = declaringBean;
        this.field = field;
        this.delegate = this.isAnnotationPresent(Decorates.class) && declaringBean instanceof Decorator;
    }

    @Override
    protected WBField<T, X> delegate() {
        return this.field;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public void inject(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            this.delegate().set(declaringInstance, manager.getInjectableReference(this, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            this.delegate().set(declaringInstance, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public Type getType() {
        return this.getBaseType();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }
}

