/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resolution;

import java.util.Collections;
import java.util.Set;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.DisposalMethod;
import org.jboss.webbeans.resolution.Resolvable;
import org.jboss.webbeans.resolution.ResolvableTransformer;
import org.jboss.webbeans.resolution.TypeSafeResolver;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeDisposerResolver
extends TypeSafeResolver<DisposalMethod<?>> {
    private final BeanManagerImpl manager;

    public TypeSafeDisposerResolver(BeanManagerImpl manager, Iterable<DisposalMethod<?>> disposers) {
        super(disposers);
        this.manager = manager;
    }

    @Override
    protected boolean matches(Resolvable resolvable, DisposalMethod<?> disposer) {
        return resolvable.getDeclaringBean().equals(disposer.getDeclaringBean()) && Reflections.isAssignableFrom(disposer.getType(), resolvable.getTypeClosure()) && Beans.containsAllBindings(disposer.getQualifiers(), resolvable.getQualifiers(), this.manager);
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }

    @Override
    protected Set<DisposalMethod<?>> filterResult(Set<DisposalMethod<?>> matched) {
        return matched;
    }

    @Override
    protected Iterable<ResolvableTransformer> getTransformers() {
        return Collections.emptySet();
    }

    @Override
    protected Set<DisposalMethod<?>> sortResult(Set<DisposalMethod<?>> matched) {
        return matched;
    }
}

