/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.javax.persistence.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.eclipse.persistence.javax.persistence.osgi.ProviderTrackerCustomizer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
PersistenceProviderResolver {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    private BundleContext ctx;
    private ServiceTracker serviceTracker;
    private Map<String, PersistenceProvider> providers;

    public void start(BundleContext context) throws Exception {
        this.log("Persistence bundle starting...");
        this.ctx = context;
        ProviderTrackerCustomizer customizer = new ProviderTrackerCustomizer(this);
        this.serviceTracker = new ServiceTracker(this.ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)customizer);
        this.serviceTracker.open();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
        this.providers = new HashMap<String, PersistenceProvider>();
        ServiceReference[] refs = null;
        try {
            refs = this.ctx.getServiceReferences(PERSISTENCE_PROVIDER, null);
        }
        catch (InvalidSyntaxException invEx) {
            // empty catch block
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                this.addProvider(ref);
            }
        }
        this.log("Persistence bundle started.");
    }

    PersistenceProvider addProvider(ServiceReference ref) {
        PersistenceProvider provider = (PersistenceProvider)this.ctx.getService(ref);
        String providerName = this.getProviderName(ref);
        this.providers.put(providerName, provider);
        return provider;
    }

    protected void removeProvider(ServiceReference ref) {
        String providerName = this.getProviderName(ref);
        this.providers.remove(providerName);
    }

    public void stop(BundleContext context) throws Exception {
        this.log("Persistence bundle stopping...");
        this.serviceTracker.close();
        this.serviceTracker = null;
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(null);
        this.log("Persistence bundle stopped.");
    }

    public String getProviderName(ServiceReference ref) {
        String providerName = (String)ref.getProperty(PERSISTENCE_PROVIDER);
        if (providerName == null) {
            providerName = "PersistenceProvider-" + ref.hashCode();
        }
        return providerName;
    }

    protected Map<String, PersistenceProvider> getProviders() {
        return this.providers;
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        return new ArrayList<PersistenceProvider>(this.getProviders().values());
    }

    private void log(String message) {
        System.out.println(message);
    }
}

