/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FacesLogger {
    APPLICATION("application"),
    APPLICATION_VIEW("application.view"),
    RESOURCE("resource"),
    CONFIG("config"),
    CONTEXT("context"),
    FACELETS_COMPILER("facelets.compiler"),
    FACELETS_COMPONENT("facelets.tag.component"),
    FACELETS_META("facelets.tag.meta"),
    FACELETS_COMPOSITION("facelets.tag.ui.composition"),
    FACELETS_DECORATE("facelets.tag.ui.decorate"),
    FACELETS_INCLUDE("facelets.tag.ui.include"),
    FACELETS_FACELET("faclets.facelet"),
    FACELETS_FACTORY("facelets.factory"),
    LIFECYCLE("lifecycle"),
    MANAGEDBEAN("managedbean"),
    RENDERKIT("renderkit"),
    TAGLIB("taglib"),
    TIMING("timing"),
    UTIL("util");

    private static final String LOGGER_RESOURCES = "com.sun.faces.LogStrings";
    public static final String FACES_LOGGER_NAME_PREFIX = "javax.enterprise.resource.webcontainer.jsf.";
    private String loggerName;

    private FacesLogger(String loggerName) {
        this.loggerName = loggerName;
    }

    public Logger getLogger() {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        ResourceBundle bundle = ResourceBundle.getBundle(LOGGER_RESOURCES, Locale.getDefault(), FacesLogger.getCurrentLoader());
        return new ResourceBundleLogger(className, Logger.getLogger(FACES_LOGGER_NAME_PREFIX + this.loggerName), bundle);
    }

    private static ClassLoader getCurrentLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesLogger.class.getClassLoader();
        }
        return loader;
    }

    private static final class ResourceBundleLogger
    extends Logger {
        private Logger delegate;
        private ResourceBundle bundle;
        private String className;

        protected ResourceBundleLogger(String className, Logger delegate, ResourceBundle bundle) {
            super(null, null);
            this.delegate = delegate;
            this.bundle = bundle;
            this.className = className;
            super.setLevel(Level.ALL);
        }

        public ResourceBundle getResourceBundle() {
            return this.bundle;
        }

        public String getResourceBundleName() {
            return FacesLogger.LOGGER_RESOURCES;
        }

        public void log(LogRecord record) {
            record.setSourceClassName(this.className);
            record.setResourceBundle(this.getResourceBundle());
            this.delegate.log(record);
        }

        public void addHandler(Handler handler) throws SecurityException {
            this.delegate.addHandler(handler);
        }

        public Filter getFilter() {
            return this.delegate.getFilter();
        }

        public Handler[] getHandlers() {
            return this.delegate.getHandlers();
        }

        public Level getLevel() {
            return this.delegate.getLevel();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Logger getParent() {
            return this.delegate.getParent();
        }

        public boolean getUseParentHandlers() {
            return this.delegate.getUseParentHandlers();
        }

        public boolean isLoggable(Level level) {
            return this.delegate.isLoggable(level);
        }

        public void removeHandler(Handler handler) throws SecurityException {
            this.delegate.removeHandler(handler);
        }

        public void setFilter(Filter newFilter) throws SecurityException {
            this.delegate.setFilter(newFilter);
        }

        public void setLevel(Level newLevel) throws SecurityException {
            this.delegate.setLevel(newLevel);
        }

        public void setParent(Logger parent) {
            this.delegate.setParent(parent);
        }

        public void setUseParentHandlers(boolean useParentHandlers) {
            this.delegate.setUseParentHandlers(useParentHandlers);
        }
    }
}

