/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.web.osgi.Extender;
import org.glassfish.web.osgi.ExtenderManager;
import org.glassfish.web.osgi.OSGiWebContainer;
import org.glassfish.web.osgi.WebBundleURLStreamHandlerService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.url.URLStreamHandlerService;

public class WebExtender
implements Extender,
SynchronousBundleListener {
    private OSGiWebContainer wc;
    private static final Logger logger = Logger.getLogger(ExtenderManager.class.getPackage().getName());
    private BundleContext context;
    private AtomicBoolean started = new AtomicBoolean(false);
    private ServiceRegistration urlHandlerService;

    public WebExtender(BundleContext context) {
        this.context = context;
    }

    public void start() {
        this.started.set(true);
        this.wc = new OSGiWebContainer();
        this.context.addBundleListener((BundleListener)this);
        for (Bundle b : this.context.getBundles()) {
            if ((b.getState() & 0x28) == 0 || !this.isWebBundle(b)) continue;
            this.deploy(b);
        }
        this.addURLHandler();
    }

    public void stop() {
        if (this.started.getAndSet(false)) {
            this.removeURLHandler();
            this.context.removeBundleListener((BundleListener)this);
            if (this.wc != null) {
                this.wc.undeployAll();
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 128: {
                if (this.isLazy(bundle) || !this.isWebBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 512: {
                if (!this.isWebBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 4: {
                if (!this.isWebBundle(bundle)) break;
                this.undeploy(bundle);
            }
        }
    }

    private boolean isLazy(Bundle bundle) {
        return "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"));
    }

    private boolean isWebBundle(Bundle b) {
        return b.getHeaders().get("Web-ContextPath") != null;
    }

    private void deploy(Bundle b) {
        try {
            this.wc.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "WebExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "WebExtender", "deploy", "Exception Stack Trace", e);
        }
    }

    private void undeploy(Bundle b) {
        try {
            this.wc.undeploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "WebExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "WebExtender", "undeploy", "Exception Stack Trace", e);
        }
    }

    private void addURLHandler() {
        Properties p = new Properties();
        p.put("url.handler.protocol", new String[]{"webbundle"});
        this.urlHandlerService = this.context.registerService(URLStreamHandlerService.class.getName(), (Object)new WebBundleURLStreamHandlerService(), (Dictionary)p);
    }

    private void removeURLHandler() {
        if (this.urlHandlerService != null) {
            this.urlHandlerService.unregister();
        }
    }
}

