/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.plugin;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admingui.plugin.ConsoleConfig;
import org.glassfish.admingui.plugin.IntegrationPoint;
import org.glassfish.admingui.plugin.TOC;
import org.glassfish.admingui.plugin.TOCItem;
import org.glassfish.api.admingui.ConsoleProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConsolePluginService {
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    ConsoleProvider[] providers;
    private boolean initialized = false;
    private MultiMap<String, IntegrationPoint> pointsByType = new MultiMap();
    private Map<String, ClassLoader> moduleClassLoaderMap = new HashMap<String, ClassLoader>();
    private Map<ClassLoader, String> classLoaderModuleMap = new HashMap<ClassLoader, String>();
    private Map<String, TOC> helpSetMap = new HashMap<String, TOC>();

    protected synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.providers != null && this.providers.length > 0) {
            ConfigParser parser = new ConfigParser(this.habitat);
            URL url = null;
            String id = null;
            for (ConsoleProvider provider : this.providers) {
                url = provider.getConfiguration();
                if (url == null) {
                    url = provider.getClass().getClassLoader().getResource("META-INF/admingui/console-config.xml");
                }
                if (url == null) {
                    if (!this.logger.isLoggable(Level.INFO)) continue;
                    this.logger.info("Unable to find META-INF/admingui/console-config.xml file for provider '" + provider.getClass().getName() + "'");
                    continue;
                }
                DomDocument doc = parser.parse(url);
                ConsoleConfig config = (ConsoleConfig)doc.getRoot().get();
                id = config.getId();
                this.moduleClassLoaderMap.put(id, provider.getClass().getClassLoader());
                this.classLoaderModuleMap.put(provider.getClass().getClassLoader(), id);
                this.addIntegrationPoints(config.getIntegrationPoints(), id);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Console Plugin Service has been Initialized!");
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.pointsByType.toString());
            }
        }
    }

    public synchronized TOC getHelpTOC(String locale) {
        TOC mergedTOC;
        if (locale == null) {
            locale = "en";
        }
        if ((mergedTOC = this.helpSetMap.get(locale)) != null) {
            return mergedTOC;
        }
        Map<String, List<URL>> mapUrls = this.getResources(locale + "/help/toc.xml");
        ConfigParser parser = new ConfigParser(this.habitat);
        mergedTOC = new TOC();
        mergedTOC.setTOCItems(new ArrayList<TOCItem>());
        mergedTOC.setVersion("2.0");
        String id = null;
        String prefix = "/" + locale + "/help/";
        List<URL> urls = null;
        for (Map.Entry<String, List<URL>> entry : mapUrls.entrySet()) {
            id = entry.getKey();
            urls = entry.getValue();
            for (URL url : urls) {
                DomDocument doc = parser.parse(url);
                TOC toc = (TOC)doc.getRoot().get();
                for (TOCItem item : toc.getTOCItems()) {
                    this.insertTOCItem(mergedTOC.getTOCItems(), item, id + prefix);
                }
            }
        }
        return mergedTOC;
    }

    private void insertTOCItem(List<TOCItem> dest, TOCItem item, String prefix) {
        int idx = dest.indexOf(item);
        if (idx == -1) {
            this.fixTargetPath(item, prefix);
            dest.add(item);
        } else {
            TOCItem parent = dest.get(idx);
            for (TOCItem child : item.getTOCItems()) {
                this.insertTOCItem(parent.getTOCItems(), child, prefix);
            }
        }
    }

    private void fixTargetPath(TOCItem parent, String prefix) {
        parent.setTargetPath(prefix + parent.getTarget() + ".html");
        for (TOCItem item : parent.getTOCItems()) {
            this.fixTargetPath(item, prefix);
        }
    }

    public Map<String, List<URL>> getResources(String name) {
        HashMap<String, List<URL>> result = new HashMap<String, List<URL>>();
        if (this.providers != null && this.providers.length > 0) {
            Enumeration<URL> urls = null;
            URL url = null;
            for (ConsoleProvider provider : this.providers) {
                ClassLoader loader = provider.getClass().getClassLoader();
                try {
                    urls = loader.getResources(name);
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.INFO)) continue;
                    this.logger.log(Level.INFO, "Error getting resource '" + name + "' from provider: '" + provider.getClass().getName() + "'. Skipping...", ex);
                    continue;
                }
                ArrayList<URL> providerURLs = new ArrayList<URL>();
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    try {
                        providerURLs.add(new URL(url, ""));
                    }
                    catch (Exception ex) {
                        System.out.println("ConsolePluginService: URL Copy Failed!");
                    }
                }
                if (providerURLs.size() <= 0) continue;
                result.put(this.classLoaderModuleMap.get(loader), providerURLs);
            }
        }
        return result;
    }

    public void addIntegrationPoints(List<IntegrationPoint> points, String id) {
        for (IntegrationPoint point : points) {
            this.addIntegrationPoint(point, id);
        }
    }

    public void addIntegrationPoint(IntegrationPoint point, String id) {
        point.setConsoleConfigId(id);
        this.pointsByType.add((Object)point.getType(), (Object)point);
    }

    public List<IntegrationPoint> getIntegrationPoints(String type) {
        this.init();
        return this.pointsByType.get((Object)type);
    }

    public ClassLoader getModuleClassLoader(String moduleName) {
        return this.moduleClassLoaderMap.get(moduleName);
    }
}

