/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="file-cache-mon", group="monitoring")
@ManagedObject
@Description(value="File Cache Statistics")
public class FileCacheStatsProvider {
    private final String name;
    private final CountStatisticImpl hitsCount = new CountStatisticImpl("HitsCount", "count", "Number of cache lookup hits");
    private final CountStatisticImpl missesCount = new CountStatisticImpl("MissesCount", "count", "Number of cache lookup misses");
    private final CountStatisticImpl infoHitsCount = new CountStatisticImpl("InfoHitsCount", "count", "Number of hits on cached file info");
    private final CountStatisticImpl infoMissesCount = new CountStatisticImpl("InfoMissesCount", "count", "Number of misses on cached file info");
    private final CountStatisticImpl contentHitsCount = new CountStatisticImpl("ContentHitsCount", "count", "Number of hits on cached file content");
    private final CountStatisticImpl contentMissesCount = new CountStatisticImpl("ContentMissesCount", "count", "Number of misses on cached file content");
    private final CountStatisticImpl openCacheEntriesCount = new CountStatisticImpl("OpenCacheEntriesCount", "count", "Number of current open cache entries");
    private final AtomicLong heapSize = new AtomicLong();
    private final AtomicLong mappedMemorySize = new AtomicLong();
    private final AtomicLong maxHeapSize = new AtomicLong();
    private final AtomicLong maxMappedMemorySize = new AtomicLong();

    public FileCacheStatsProvider(String name) {
        this.name = name;
    }

    @ManagedAttribute(id="hits")
    @Description(value="Number of cache lookup hits")
    public CountStatistic getHitsCount() {
        return this.hitsCount;
    }

    @ManagedAttribute(id="misses")
    @Description(value="Number of cache lookup misses")
    public CountStatistic getMissesCount() {
        return this.missesCount;
    }

    @ManagedAttribute(id="infohits")
    @Description(value="Number of hits on cached file info")
    public CountStatistic getInfoHitsCount() {
        return this.infoHitsCount;
    }

    @ManagedAttribute(id="infomisses")
    @Description(value="Number of misses on cached file info")
    public CountStatistic getInfoMissesCount() {
        return this.infoMissesCount;
    }

    @ManagedAttribute(id="contenthits")
    @Description(value="Number of hits on cached file content")
    public CountStatistic getContentHitsCount() {
        return this.contentHitsCount;
    }

    @ManagedAttribute(id="contentmisses")
    @Description(value="Number of misses on cached file content")
    public CountStatistic getContentMissesCount() {
        return this.contentMissesCount;
    }

    @ManagedAttribute(id="opencacheentries")
    @Description(value="Number of current open cache entries")
    public CountStatistic getOpenCacheEntriesCount() {
        return this.openCacheEntriesCount;
    }

    @ManagedAttribute(id="heapsize")
    @Description(value="Current cache size in bytes")
    public CountStatistic getHeapSize() {
        CountStatisticImpl stats = new CountStatisticImpl("HeapSize", "byte(s)", "Current cache size in bytes");
        stats.setCount(this.heapSize.get());
        return stats;
    }

    @ManagedAttribute(id="maxheapsize")
    @Description(value="Maximum heap space used for cache")
    public CountStatistic getMaxHeapSize() {
        CountStatisticImpl stats = new CountStatisticImpl("MaxHeapSize", "byte(s)", "Maximum heap space used for cache");
        stats.setCount(this.maxHeapSize.get());
        return stats;
    }

    @ManagedAttribute(id="mappedmemorysize")
    @Description(value="Size of mapped memory used for caching")
    public CountStatistic getMappedMemorySize() {
        CountStatisticImpl stats = new CountStatisticImpl("MappedMemorySize", "byte(s)", "Size of mapped memory used for caching");
        stats.setCount(this.mappedMemorySize.get());
        return stats;
    }

    @ManagedAttribute(id="maxmappedmemorysize")
    @Description(value="Maximum memory map size to be used for caching")
    public CountStatistic getMaxMappedMemorySize() {
        CountStatisticImpl stats = new CountStatisticImpl("MaxMappedMemorySize", "byte(s)", "Maximum memory map size to be used for caching");
        stats.setCount(this.maxMappedMemorySize.get());
        return stats;
    }

    @ProbeListener(value="glassfish:kernel:file-cache:countHitEvent")
    public void countHitEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.hitsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:countMissEvent")
    public void countMissEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.missesCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:countInfoHitEvent")
    public void countInfoHitEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.infoHitsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:countInfoMissEvent")
    public void countInfoMissEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.infoMissesCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:countContentHitEvent")
    public void countContentHitEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.contentHitsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:countContentMissEvent")
    public void countContentMissEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.contentMissesCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:incOpenCacheEntriesEvent")
    public void incOpenCacheEntriesEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.openCacheEntriesCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:decOpenCacheEntriesEvent")
    public void decOpenCacheEntriesEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        if (this.name.equals(fileCacheName)) {
            this.openCacheEntriesCount.decrement();
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:addHeapSizeEvent")
    public void addHeapSizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        block1: {
            long maxSize;
            if (!this.name.equals(fileCacheName)) break block1;
            long newSize = this.heapSize.addAndGet(size);
            while (newSize > (maxSize = this.maxHeapSize.get()) && !this.maxHeapSize.compareAndSet(maxSize, newSize)) {
            }
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:subHeapSizeEvent")
    public void subHeapSizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        if (this.name.equals(fileCacheName)) {
            this.heapSize.addAndGet(-size);
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:addMappedMemorySizeEvent")
    public void addMappedMemorySizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        block1: {
            long maxMemSize;
            if (!this.name.equals(fileCacheName)) break block1;
            long newSize = this.mappedMemorySize.addAndGet(size);
            while (newSize > (maxMemSize = this.maxMappedMemorySize.get()) && !this.maxMappedMemorySize.compareAndSet(maxMemSize, newSize)) {
            }
        }
    }

    @ProbeListener(value="glassfish:kernel:file-cache:subMappedMemorySizeEvent")
    public void subMappedMemorySizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        if (this.name.equals(fileCacheName)) {
            this.mappedMemorySize.addAndGet(-size);
        }
    }
}

