/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic,
InvocationHandler {
    private AtomicLong count = new AtomicLong(Long.MIN_VALUE);
    private final long timeNow = System.currentTimeMillis();
    private AtomicLong maxTime = new AtomicLong(this.timeNow);
    private AtomicLong minTime = new AtomicLong(this.timeNow);
    private AtomicLong totTime = new AtomicLong(0L);
    private TimeStatistic ts = (TimeStatistic)Proxy.newProxyInstance(TimeStatistic.class.getClassLoader(), new Class[]{TimeStatistic.class}, (InvocationHandler)this);

    public final String toString() {
        return super.toString() + NEWLINE + "Count: " + this.getCount() + NEWLINE + "MinTime: " + this.getMinTime() + NEWLINE + "MaxTime: " + this.getMaxTime() + NEWLINE + "TotalTime: " + this.getTotalTime();
    }

    public TimeStatisticImpl(long counter, long maximumTime, long minimumTime, long totalTime, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.count.set(counter);
        this.maxTime.set(maximumTime);
        this.minTime.set(minimumTime);
        this.totTime.set(totalTime);
    }

    public synchronized TimeStatistic getStatistic() {
        return this.ts;
    }

    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("count", this.getCount());
        m.put("maxtime", this.getMaxTime());
        m.put("mintime", this.getMinTime());
        m.put("totaltime", this.getTotalTime());
        return m;
    }

    public void incrementCount(long current) {
        if (this.count.get() == 0L) {
            this.totTime.set(current);
            this.maxTime.set(current);
            this.minTime.set(current);
        } else {
            this.totTime.addAndGet(current);
            this.maxTime.set(current >= this.maxTime.get() ? current : this.maxTime.get());
            this.minTime.set(current >= this.minTime.get() ? this.minTime.get() : current);
        }
        this.count.incrementAndGet();
        super.setLastSampleTime(System.currentTimeMillis());
    }

    public long getCount() {
        return this.count.get();
    }

    public void setCount(long counter) {
        this.count.set(counter);
    }

    public long getMaxTime() {
        return this.maxTime.get();
    }

    public void setMaxTime(long maximumTime) {
        this.maxTime.set(maximumTime);
    }

    public long getMinTime() {
        return this.minTime.get();
    }

    public void setMinTime(long minimumTime) {
        this.minTime.set(minimumTime);
    }

    public long getTotalTime() {
        return this.totTime.get();
    }

    public void setTotalTime(long totalTime) {
        this.totTime.set(totalTime);
    }

    public void reset() {
        super.reset();
        this.count.set(Long.MIN_VALUE);
        this.maxTime.set(System.currentTimeMillis());
        this.minTime.set(System.currentTimeMillis());
        this.totTime.set(0L);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            result = m.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

