/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMapper
implements Serializable,
SecurityRoleMapper {
    private static final String DEFAULT_ROLE_NAME = "ANYONE";
    private Role defaultRole = null;
    private String defaultRoleName = null;
    private String appName;
    private final Map<String, Subject> roleToSubject = new HashMap<String, Subject>();
    private String defaultP2RMappingClassName = null;
    private DefaultRoleToSubjectMapping defaultRTSM = new DefaultRoleToSubjectMapping();
    private final Map<String, Set<Principal>> roleToPrincipal = new HashMap<String, Set<Principal>>();
    private final Map<String, Set<Group>> roleToGroup = new HashMap<String, Set<Group>>();
    private Mapping currentMapping;
    private Set<Role> topLevelRoles;
    private static final String TOP_LEVEL = "sun-application.xml mapping file";
    private boolean conflictLogged = false;
    private Set<Role> conflictedRoles;
    private static Logger _logger = LogDomains.getLogger(RoleMapper.class, (String)"javax.enterprise.system.core.security");
    private SecurityService secService = null;

    RoleMapper(String appName) {
        this.appName = appName;
        this.secService = Globals.getDefaultHabitat().getComponent(SecurityService.class);
        this.defaultP2RMappingClassName = this.getDefaultP2RMappingClassName();
        this.postConstruct();
    }

    private synchronized void initDefaultRole() {
        if (this.defaultRole == null) {
            this.defaultRoleName = DEFAULT_ROLE_NAME;
            try {
                assert (this.secService != null);
                this.defaultRoleName = this.secService.getAnonymousRole();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "java_security.anonymous_role_reading_exception", e);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Default role is: " + this.defaultRoleName);
            }
            this.defaultRole = new Role(this.defaultRoleName);
        }
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    private void addRoleToPrincipal(final Principal principal, String role) {
        assert (this.roleToSubject != null);
        Subject subject = this.roleToSubject.get(role);
        final Subject sub = subject == null ? new Subject() : subject;
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(principal);
                return null;
            }
        });
        this.roleToSubject.put(role, sub);
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        assert (this.roleToSubject != null);
        String mrole = role.getName();
        final Subject sub = this.roleToSubject.get(mrole);
        final Principal p = principal;
        if (sub != null) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sub.getPrincipals().remove(p);
                    return null;
                }
            });
            this.roleToSubject.put(mrole, sub);
        }
        if (principal instanceof Group) {
            Set<Group> groups = this.roleToGroup.get(mrole);
            if (groups != null) {
                groups.remove((Group)principal);
                this.roleToGroup.put(mrole, groups);
            }
        } else {
            Set<Principal> principals = this.roleToPrincipal.get(mrole);
            if (principals != null) {
                principals.remove(principal);
                this.roleToPrincipal.put(mrole, principals);
            }
        }
    }

    boolean isDefaultRTSMActivated() {
        return this.defaultP2RMappingClassName != null;
    }

    public Map getRoleToSubjectMapping() {
        this.checkAndAddMappings();
        assert (this.roleToSubject != null);
        if (this.roleToSubject.isEmpty() && this.isDefaultRTSMActivated()) {
            return this.defaultRTSM;
        }
        return this.roleToSubject;
    }

    private void internalAssignRole(Principal p, Role r) {
        String role = r.getName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SECURITY:RoleMapper Assigning Role " + role + " to  " + p.getName());
        }
        this.addRoleToPrincipal(p, role);
        if (p instanceof Group) {
            Set<Group> groups = this.roleToGroup.get(role);
            if (groups == null) {
                groups = new HashSet<Group>();
            }
            groups.add((Group)p);
            this.roleToGroup.put(role, groups);
        } else {
            Set<Principal> principals = this.roleToPrincipal.get(role);
            if (principals == null) {
                principals = new HashSet<Principal>();
            }
            principals.add(p);
            this.roleToPrincipal.put(role, principals);
        }
    }

    public void assignRole(Principal p, Role r, RootDeploymentDescriptor rdd) {
        assert (rdd != null);
        String callingModuleID = this.getModuleID(rdd);
        if (this.currentMapping == null) {
            this.currentMapping = new Mapping(callingModuleID);
        } else if (!callingModuleID.equals(this.currentMapping.owner)) {
            this.checkAndAddMappings();
            this.currentMapping = new Mapping(callingModuleID);
        }
        if (callingModuleID.equals(TOP_LEVEL) && this.topLevelRoles == null) {
            this.topLevelRoles = new HashSet<Role>();
        }
        this.currentMapping.addMapping(p, r);
    }

    public Iterator getRoles() {
        assert (this.roleToSubject != null);
        return this.roleToSubject.keySet().iterator();
    }

    public Enumeration getGroupsAssignedTo(Role r) {
        assert (this.roleToGroup != null);
        Set<Group> s = this.roleToGroup.get(r.getName());
        if (s == null) {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
        return Collections.enumeration(s);
    }

    public Enumeration getUsersAssignedTo(Role r) {
        assert (this.roleToPrincipal != null);
        Set<Principal> s = this.roleToPrincipal.get(r.getName());
        if (s == null) {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
        return Collections.enumeration(s);
    }

    public void unassignRole(Role r) {
        if (r != null) {
            String role = r.getName();
            this.roleToSubject.remove(role);
            this.roleToPrincipal.remove(role);
            this.roleToGroup.remove(role);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("RoleMapper:");
        Iterator e = this.getRoles();
        while (e.hasNext()) {
            String r = (String)e.next();
            s.append("\n\tRole (" + r + ") has Principals(");
            Subject sub = this.roleToSubject.get(r);
            for (Principal p : sub.getPrincipals()) {
                s.append(p.getName() + " ");
            }
            s.append(")");
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, s.toString());
        }
        return s.toString();
    }

    public RoleMapper(RoleMapper r) {
        this.appName = r.getName();
        Iterator it = r.getRoles();
        while (it.hasNext()) {
            String role = (String)it.next();
            Enumeration groups = r.getGroupsAssignedTo(new Role(role));
            HashSet<Group> groupsToRole = new HashSet<Group>();
            while (groups.hasMoreElements()) {
                Group gp = (Group)groups.nextElement();
                groupsToRole.add(new Group(gp.getName()));
                this.addRoleToPrincipal((Principal)gp, role);
            }
            this.roleToGroup.put(role, groupsToRole);
            Enumeration users = r.getUsersAssignedTo(new Role(role));
            HashSet<PrincipalImpl> usersToRole = new HashSet<PrincipalImpl>();
            while (users.hasMoreElements()) {
                PrincipalImpl gp = (PrincipalImpl)users.nextElement();
                usersToRole.add(new PrincipalImpl(gp.getName()));
                this.addRoleToPrincipal((Principal)gp, role);
            }
            this.roleToPrincipal.put(role, usersToRole);
        }
    }

    private String getDefaultP2RMappingClassName() {
        String className = null;
        try {
            if (this.secService != null && Boolean.parseBoolean(this.secService.getActivateDefaultPrincipalToRoleMapping()) && ((className = this.secService.getMappedPrincipalClass()) == null || "".equals(className))) {
                className = Group.class.getName();
            }
            if (className == null) {
                return null;
            }
            Class<?> clazz = Class.forName(className);
            Class[] argClasses = new Class[]{String.class};
            Object[] arg = new Object[]{"anystring"};
            Constructor<?> c = clazz.getConstructor(argClasses);
            Principal principal = (Principal)c.newInstance(arg);
            return className;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "pc.getDefaultP2RMappingClass: " + e);
            return null;
        }
    }

    private String getModuleID(RootDeploymentDescriptor rdd) {
        if (rdd.isApplication()) {
            return TOP_LEVEL;
        }
        if (rdd.getModuleDescriptor() != null) {
            return rdd.getModuleDescriptor().getArchiveUri();
        }
        throw new AssertionError((Object)(rdd.getClass() + " is not a known descriptor type"));
    }

    private void checkAndAddMappings() {
        if (this.currentMapping == null) {
            return;
        }
        for (Role r : this.currentMapping.getRoles()) {
            if (this.topLevelRoles != null && this.topLevelRoles.contains(r)) {
                this.logConflictWarning();
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Role " + r + " from module " + this.currentMapping.owner + " is being overridden by top-level mapping.");
                continue;
            }
            if (this.currentMapping.owner.equals(TOP_LEVEL)) {
                this.topLevelRoles.add(r);
                if (this.roleToSubject.keySet().contains(r.getName())) {
                    this.logConflictWarning();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Role " + r + " from top-level mapping descriptor is " + "overriding existing role in sub module.");
                    }
                    this.unassignRole(r);
                }
            } else if (this.roleConflicts(r, this.currentMapping.getPrincipals(r))) {
                this.logConflictWarning();
                this.unassignRole(r);
                continue;
            }
            for (Principal p : this.currentMapping.getPrincipals(r)) {
                this.internalAssignRole(p, r);
            }
        }
        this.currentMapping = null;
    }

    private boolean roleConflicts(Role r, Set<Principal> ps) {
        if (this.conflictedRoles != null && this.conflictedRoles.contains(r)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Role " + r + " from module " + this.currentMapping.owner + " has already had a conflict with other modules.");
            }
            return true;
        }
        if (!this.roleToSubject.keySet().contains(r.getName())) {
            return false;
        }
        int targetNumPrin = ps.size();
        int actualNum = 0;
        Set<Principal> pSet = this.roleToPrincipal.get(r.getName());
        Set<Group> gSet = this.roleToGroup.get(r.getName());
        actualNum += pSet == null ? 0 : pSet.size();
        if (targetNumPrin != (actualNum += gSet == null ? 0 : gSet.size())) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Module " + this.currentMapping.owner + " has different number of mappings for role " + r.getName() + " than other mapping files");
            }
            if (this.conflictedRoles == null) {
                this.conflictedRoles = new HashSet<Role>();
            }
            this.conflictedRoles.add(r);
            return true;
        }
        boolean fail = false;
        for (Principal p : ps) {
            if (p instanceof Group) {
                if (gSet != null && !gSet.contains((Group)p)) {
                    fail = true;
                }
            } else if (pSet != null && !pSet.contains(p)) {
                fail = true;
            }
            if (!fail) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Role " + r + " in module " + this.currentMapping.owner + " is not included in other modules.");
            }
            if (this.conflictedRoles == null) {
                this.conflictedRoles = new HashSet<Role>();
            }
            this.conflictedRoles.add(r);
            return true;
        }
        return false;
    }

    private void logConflictWarning() {
        if (!this.conflictLogged) {
            _logger.log(Level.WARNING, "java_security.role_mapping_conflict", this.getName());
            this.conflictLogged = true;
        }
    }

    public void postConstruct() {
    }

    class DefaultRoleToSubjectMapping
    extends HashMap {
        private HashMap roleMap = new HashMap();

        DefaultRoleToSubjectMapping() {
        }

        Principal getSameNamedPrincipal(String roleName) {
            try {
                Class<?> clazz = Class.forName(RoleMapper.this.defaultP2RMappingClassName);
                Class[] argClasses = new Class[]{String.class};
                Object[] arg = new Object[]{new String(roleName)};
                Constructor<?> c = clazz.getConstructor(argClasses);
                Principal principal = (Principal)c.newInstance(arg);
                return principal;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "rm.getSameNamedPrincipal", new Object[]{roleName, e});
                throw new RuntimeException("Unable to get principal by default p2r mapping");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            assert (key instanceof String);
            HashMap hashMap = this.roleMap;
            synchronized (hashMap) {
                Subject s = (Subject)this.roleMap.get(key);
                if (s == null && key instanceof String) {
                    final Subject fs = new Subject();
                    final String roleName = (String)key;
                    AppservAccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            fs.getPrincipals().add(DefaultRoleToSubjectMapping.this.getSameNamedPrincipal(roleName));
                            return null;
                        }
                    });
                    this.roleMap.put(key, fs);
                    s = fs;
                }
                return s;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Mapping
    implements Serializable {
        private final String owner;
        private final Map<Role, Set<Principal>> roleMap;

        Mapping(String owner) {
            this.owner = owner;
            this.roleMap = new HashMap<Role, Set<Principal>>();
        }

        void addMapping(Principal p, Role r) {
            Set<Principal> pSet = this.roleMap.get(r);
            if (pSet == null) {
                pSet = new HashSet<Principal>();
                this.roleMap.put(r, pSet);
            }
            pSet.add(p);
        }

        Set<Role> getRoles() {
            return this.roleMap.keySet();
        }

        Set<Principal> getPrincipals(Role r) {
            return this.roleMap.get(r);
        }
    }
}

