/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="ejb-timed-object-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Ejb Timed Object Statistics")
public class EjbTimedObjectStatsProvider {
    private CountStatisticImpl timerCreateStat = new CountStatisticImpl("NumTimersCreated", "count", "Number of timers created in the system");
    private CountStatisticImpl timerRemoveStat = new CountStatisticImpl("NumTimersRemoved", "count", "Number of timers removed from the system");
    private CountStatisticImpl timerDeliveredStat = new CountStatisticImpl("NumTimersDelivered", "count", "Number of timers delivered by the system");
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    private String appName = null;
    private String moduleName = null;
    private String beanName = null;
    private boolean registered = false;

    public EjbTimedObjectStatsProvider(String appName, String moduleName, String beanName) {
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
    }

    public void register() {
        String node = EjbMonitoringUtils.registerSubComponent(this.appName, this.moduleName, this.beanName, "timers", this);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
        }
    }

    @ProbeListener(value="glassfish:ejb:timers:timerCreatedEvent")
    public void ejbTimerCreatedEvent() {
        _logger.fine("=== timerCreatedEvent");
        this.timerCreateStat.increment();
    }

    @ProbeListener(value="glassfish:ejb:timers:timerRemovedEvent")
    public void ejbTimerRemovedEvent() {
        _logger.fine("=== timerRemovedEvent");
        this.timerRemoveStat.increment();
    }

    @ProbeListener(value="glassfish:ejb:timers:timerDeliveredEvent")
    public void ejbTimerDeliveredEvent() {
        _logger.fine("=== timerDeliveredEvent");
        this.timerDeliveredStat.increment();
    }

    @ManagedAttribute(id="numtimerscreated")
    @Description(value="Number of timers created in the system")
    public CountStatistic getNumTimersCreated() {
        return this.timerCreateStat.getStatistic();
    }

    @ManagedAttribute(id="numtimersremoved")
    @Description(value="Number of timers removed from the system")
    public CountStatistic getNumTimersRemoved() {
        return this.timerRemoveStat.getStatistic();
    }

    @ManagedAttribute(id="numtimersdelivered")
    @Description(value="Number of timers delivered by the system")
    public CountStatistic getNumTimersDelivered() {
        return this.timerDeliveredStat.getStatistic();
    }
}

