/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLEventReaderReader
extends XMLReader {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errorHandler;
    private int depth = 0;
    private HashMap<Integer, ArrayList<Namespace>> namespaces = new HashMap();

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler aContentHandler) {
        this.contentHandler = aContentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler anErrorHandler) {
        this.errorHandler = anErrorHandler;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        }
    }

    public void parse(InputSource input) throws SAXException {
        if (input instanceof XMLEventReaderInputSource) {
            XMLEventReader xmlEventReader = ((XMLEventReaderInputSource)input).getXmlEventReader();
            this.parse(xmlEventReader);
        }
    }

    public void parse(String systemId) throws SAXException {
    }

    private void parse(XMLEventReader xmlEventReader) throws SAXException {
        try {
            this.getContentHandler().startDocument();
            XMLEvent firstEvent = xmlEventReader.nextEvent();
            this.parseEvent(firstEvent);
            while (this.depth > 0 && xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                this.parseEvent(xmlEvent);
            }
            this.getContentHandler().endDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void parseEvent(XMLEvent xmlEvent) throws SAXException {
        if (null == this.getContentHandler()) {
            return;
        }
        switch (xmlEvent.getEventType()) {
            case 10: {
                break;
            }
            case 12: {
                Characters characters = xmlEvent.asCharacters();
                if (null == this.lexicalHandler) {
                    this.getContentHandler().characters(characters.getData().toCharArray(), 0, characters.getData().length());
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.getContentHandler().characters(characters.getData().toCharArray(), 0, characters.getData().length());
                this.lexicalHandler.endCDATA();
                break;
            }
            case 4: {
                Characters characters = xmlEvent.asCharacters();
                this.getContentHandler().characters(characters.getData().toCharArray(), 0, characters.getData().length());
                break;
            }
            case 5: {
                if (null == this.lexicalHandler) break;
                Comment comment = (Comment)xmlEvent;
                this.lexicalHandler.comment(comment.getText().toCharArray(), 0, comment.getText().length());
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 2: {
                ArrayList<Namespace> declaredNs = this.namespaces.get(new Integer(this.depth));
                --this.depth;
                EndElement endElement = xmlEvent.asEndElement();
                QName name = endElement.getName();
                String prefix = endElement.getName().getPrefix();
                if (null == prefix || prefix.length() == 0) {
                    this.getContentHandler().endElement(name.getNamespaceURI(), name.getLocalPart(), name.getLocalPart());
                } else {
                    this.getContentHandler().endElement(name.getNamespaceURI(), name.getLocalPart(), prefix + ':' + name.getLocalPart());
                }
                if (declaredNs == null) break;
                for (Namespace next : declaredNs) {
                    this.getContentHandler().endPrefixMapping(next.getPrefix());
                }
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)xmlEvent;
                this.getContentHandler().processingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 6: {
                char[] characters = xmlEvent.asCharacters().getData().toCharArray();
                this.getContentHandler().characters(characters, 0, characters.length);
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 1: {
                QName qName;
                String prefix;
                ++this.depth;
                StartElement startElement = xmlEvent.asStartElement();
                Iterator<Namespace> namespaces = startElement.getNamespaces();
                ArrayList<Namespace> declaredNs = null;
                if (namespaces.hasNext()) {
                    declaredNs = new ArrayList<Namespace>();
                }
                while (namespaces.hasNext()) {
                    Namespace next = namespaces.next();
                    this.getContentHandler().startPrefixMapping(next.getPrefix(), next.getNamespaceURI());
                    declaredNs.add(next);
                }
                if (declaredNs != null) {
                    this.namespaces.put(new Integer(this.depth), declaredNs);
                }
                if (null == (prefix = (qName = startElement.getName()).getPrefix()) || prefix.length() == 0) {
                    this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), new IndexedAttributeList(startElement.getAttributes(), startElement.getNamespaces()));
                    break;
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), prefix + ':' + qName.getLocalPart(), new IndexedAttributeList(startElement.getAttributes(), startElement.getNamespaces()));
                break;
            }
        }
    }

    private static class Attribute {
        private QName qName;
        private String name;
        private String value;

        public Attribute(String uri, String localName, String name, String value) {
            this.qName = new QName(uri, localName);
            this.name = name;
            this.value = value;
        }

        public QName getQName() {
            return this.qName;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class IndexedAttributeList
    implements Attributes {
        private List<Attribute> attributes = new ArrayList<Attribute>();

        public IndexedAttributeList(Iterator attrs, Iterator namespaces) {
            String localName;
            String uri;
            javax.xml.stream.events.Attribute next;
            while (namespaces.hasNext()) {
                String qName;
                next = (Namespace)namespaces.next();
                uri = "http://www.w3.org/2000/xmlns/";
                localName = next.getPrefix();
                if (null == localName || localName.length() == 0) {
                    localName = "xmlns";
                    qName = "xmlns";
                } else {
                    qName = "xmlns:" + localName;
                }
                String value = next.getNamespaceURI();
                this.attributes.add(new Attribute(uri, localName, qName, value));
            }
            while (attrs.hasNext()) {
                next = (javax.xml.stream.events.Attribute)attrs.next();
                uri = next.getName().getNamespaceURI();
                localName = next.getName().getLocalPart();
                String prefix = next.getName().getPrefix();
                String qName = null == prefix || prefix.length() == 0 ? localName : prefix + ':' + localName;
                String value = next.getValue();
                this.attributes.add(new Attribute(uri, localName, qName, value));
            }
        }

        public int getIndex(String qName) {
            if (null == qName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes) {
                if (qName.equals(attribute.getName())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            if (null == localName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes) {
                QName testQName = new QName(uri, localName);
                if (attribute.getQName().equals(testQName)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int getLength() {
            return this.attributes.size();
        }

        public String getLocalName(int index) {
            return this.attributes.get(index).getQName().getLocalPart();
        }

        public String getQName(int index) {
            return this.attributes.get(index).getName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String name) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getURI(int index) {
            return this.attributes.get(index).getQName().getNamespaceURI();
        }

        public String getValue(int index) {
            return this.attributes.get(index).getValue();
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (-1 == index) {
                return null;
            }
            return this.attributes.get(index).getValue();
        }

        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (-1 == index) {
                return null;
            }
            return this.attributes.get(index).getValue();
        }
    }
}

