/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition
extends DatabaseObjectDefinition {
    protected Vector<FieldDefinition> fields = new Vector();
    protected HashMap<String, ForeignKeyConstraint> foreignKeyMap = new HashMap();
    protected Vector<UniqueKeyConstraint> uniqueKeys = new Vector();
    protected String creationPrefix = "CREATE TABLE ";
    protected String creationSuffix = "";
    private boolean createSQLFiles;

    public void addField(String fieldName, Class type) {
        this.addField(new FieldDefinition(fieldName, type));
    }

    public void addField(String fieldName, Class type, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize));
    }

    public void addField(String fieldName, Class type, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().addElement(field);
    }

    public void addForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        ForeignKeyConstraint foreignKey = new ForeignKeyConstraint(name, sourceField, targetField, targetTable);
        this.addForeignKeyConstraint(foreignKey);
    }

    public void addUniqueKeyConstraint(String name, String sourceField) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceField);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addUniqueKeyConstraint(String name, String[] sourceFields) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceFields);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKey) {
        if (!this.foreignKeyMap.containsKey(foreignKey.getName())) {
            this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
        }
    }

    public void addUniqueKeyConstraint(UniqueKeyConstraint uniqueKey) {
        this.getUniqueKeys().addElement(uniqueKey);
    }

    public void addIdentityField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addIdentityField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public Writer buildConstraintCreationWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKey.getName() + " ");
            }
            foreignKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + foreignKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintCreationWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(uniqueKey.getName() + " ");
            }
            uniqueKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + uniqueKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintDeletionWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + uniqueKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildIndexCreationWriter(AbstractSession session, String key, List<String> columnNames, Writer writer) throws ValidationException {
        try {
            String indexName = this.buildIndexName(this.getName(), key, session.getPlatform().getMaxIndexNameSize(), session.getPlatform());
            writer.write(session.getPlatform().buildCreateIndex(this.getFullName(), indexName, columnNames.toArray(new String[0])));
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildIndexDeletionWriter(AbstractSession session, String key, Writer writer) throws ValidationException {
        try {
            String indexName = this.buildIndexName(this.getName(), key, session.getPlatform().getMaxIndexNameSize(), session.getPlatform());
            writer.write(session.getPlatform().buildDropIndex(this.getFullName(), indexName));
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public String getCreationPrefix() {
        return this.creationPrefix;
    }

    public void setCreationPrefix(String creationPrefix) {
        this.creationPrefix = creationPrefix;
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.creationSuffix = creationSuffix;
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(this.getCreationPrefix() + this.getFullName() + " (");
            Enumeration<FieldDefinition> fieldsEnum = this.getFields().elements();
            while (fieldsEnum.hasMoreElements()) {
                FieldDefinition field = fieldsEnum.nextElement();
                field.appendDBString(writer, session, this);
                if (!fieldsEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            Vector<String> keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (session.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + this.getFullName() + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                Enumeration<String> keyEnum = keyFields.elements();
                while (keyEnum.hasMoreElements()) {
                    writer.write(keyEnum.nextElement());
                    if (!keyEnum.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            if (session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
                for (UniqueKeyConstraint constraint : this.getUniqueKeys()) {
                    writer.write(", ");
                    constraint.appendDBString(writer, session);
                }
            }
            writer.write(")");
            if (this.getCreationSuffix().length() > 0) {
                writer.write(this.getCreationSuffix());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    protected void buildFieldTypes(AbstractSession session) {
        FieldDefinition field = null;
        Enumeration<FieldDefinition> enumtr = this.getFields().elements();
        while (enumtr.hasMoreElements()) {
            field = enumtr.nextElement();
            if (field.getForeignKeyFieldName() == null) continue;
            this.addForeignKeyConstraint(this.buildForeignKeyConstraint(field, session.getPlatform()));
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition field, DatabasePlatform platform) {
        Vector<String> sourceFields = new Vector<String>();
        Vector<String> targetFields = new Vector<String>();
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        DatabaseField tempTargetField = new DatabaseField(field.getForeignKeyFieldName());
        DatabaseField tempSourceField = new DatabaseField(field.getName());
        sourceFields.addElement(tempSourceField.getName());
        targetFields.addElement(tempTargetField.getName());
        fkConstraint.setSourceFields(sourceFields);
        fkConstraint.setTargetFields(targetFields);
        fkConstraint.setTargetTable(tempTargetField.getTable().getQualifiedNameDelimited(platform));
        String tempName = this.buildForeignKeyConstraintName(this.getName(), tempSourceField.getName(), platform.getMaxForeignKeyNameSize(), platform);
        fkConstraint.setName(tempName);
        return fkConstraint;
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(Vector fkFieldNames, Vector pkFieldNames, TableDefinition targetTable, DatabasePlatform platform) {
        assert (fkFieldNames.size() > 0 && fkFieldNames.size() == pkFieldNames.size());
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        for (int i = 0; i < fkFieldNames.size(); ++i) {
            fkConstraint.getSourceFields().add(fkFieldNames.get(i));
            fkConstraint.getTargetFields().add(pkFieldNames.get(i));
        }
        fkConstraint.setTargetTable(targetTable.getFullName());
        String fkFieldName = (String)fkFieldNames.get(0);
        String name = this.buildForeignKeyConstraintName(this.getName(), fkFieldName, platform.getMaxForeignKeyNameSize(), platform);
        fkConstraint.setName(name);
        return fkConstraint;
    }

    protected String buildForeignKeyConstraintName(String tableName, String fieldName, int maximumNameLength, DatabasePlatform platform) {
        char c;
        int i;
        StringBuffer buff;
        String adjustedTableName;
        boolean useDelimiters;
        String startDelimiter = "";
        String endDelimiter = "";
        boolean bl = useDelimiters = !platform.getStartDelimiter().equals("") && (tableName.startsWith(platform.getStartDelimiter()) || fieldName.startsWith(platform.getStartDelimiter()));
        if (useDelimiters) {
            startDelimiter = platform.getStartDelimiter();
            endDelimiter = platform.getEndDelimiter();
        }
        if ((adjustedTableName = tableName).indexOf(32) != -1 || adjustedTableName.indexOf(34) != -1 || adjustedTableName.indexOf(96) != -1) {
            buff = new StringBuffer();
            for (i = 0; i < tableName.length(); ++i) {
                c = tableName.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                buff.append(c);
            }
            adjustedTableName = buff.toString();
        }
        buff = new StringBuffer();
        for (i = 0; i < fieldName.length(); ++i) {
            c = fieldName.charAt(i);
            if (c == ' ' || c == '\"' || c == '`') continue;
            buff.append(c);
        }
        String adjustedFieldName = buff.toString();
        String foreignKeyName = startDelimiter + "FK_" + adjustedTableName + "_" + adjustedFieldName + endDelimiter;
        if (foreignKeyName.length() > maximumNameLength && (foreignKeyName = startDelimiter + adjustedTableName + "_" + adjustedFieldName + endDelimiter).length() > maximumNameLength && (foreignKeyName = startDelimiter + Helper.removeAllButAlphaNumericToFit(adjustedTableName + adjustedFieldName, maximumNameLength) + endDelimiter).length() > maximumNameLength) {
            String onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(adjustedTableName, 0);
            String onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(adjustedFieldName, 0);
            foreignKeyName = startDelimiter + Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName, onlyAlphaNumericFieldName, maximumNameLength) + endDelimiter;
            if (foreignKeyName.length() > maximumNameLength) {
                String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
                String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
                int delimiterLength = startDelimiter.length() + endDelimiter.length();
                foreignKeyName = shortenedFieldName.length() + delimiterLength >= maximumNameLength ? startDelimiter + Helper.truncate(shortenedFieldName, maximumNameLength - delimiterLength) + endDelimiter : startDelimiter + Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length() - delimiterLength) + shortenedFieldName + endDelimiter;
            }
        }
        return foreignKeyName;
    }

    protected UniqueKeyConstraint buildUniqueKeyConstraint(List<String> fieldNames, int serialNumber, DatabasePlatform platform) {
        assert (fieldNames.size() > 0);
        UniqueKeyConstraint unqConstraint = new UniqueKeyConstraint();
        for (String fieldName : fieldNames) {
            unqConstraint.addSourceField(fieldName);
        }
        String name = this.buildUniqueKeyConstraintName(this.getName(), serialNumber, platform.getMaxUniqueKeyNameSize());
        unqConstraint.setName(name);
        return unqConstraint;
    }

    protected String buildUniqueKeyConstraintName(String tableName, int serialNumber, int maximumNameLength) {
        String serialName;
        String onlyAlphaNumericTableName;
        String uniqueKeyName = "UNQ_" + tableName + "_" + serialNumber;
        if (uniqueKeyName.length() > maximumNameLength && (uniqueKeyName = tableName + serialNumber).length() > maximumNameLength && (uniqueKeyName = Helper.removeAllButAlphaNumericToFit(tableName + serialNumber, maximumNameLength)).length() > maximumNameLength && (uniqueKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), serialName = String.valueOf(serialNumber), maximumNameLength)).length() > maximumNameLength) {
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            uniqueKeyName = Helper.truncate(shortenedTableName, maximumNameLength - serialName.length()) + serialName;
        }
        return uniqueKeyName;
    }

    protected String buildIndexName(String tableName, String key, int maximumNameLength, DatabasePlatform platform) {
        char c;
        int i;
        StringBuffer buff;
        String adjustedTableName;
        boolean useDelimiters;
        String startDelimiter = "";
        String endDelimiter = "";
        boolean bl = useDelimiters = !platform.getStartDelimiter().equals("") && (tableName.startsWith(platform.getStartDelimiter()) || key.startsWith(platform.getStartDelimiter()));
        if (useDelimiters) {
            startDelimiter = platform.getStartDelimiter();
            endDelimiter = platform.getEndDelimiter();
        }
        if ((adjustedTableName = tableName).indexOf(32) != -1 || adjustedTableName.indexOf(34) != -1 || adjustedTableName.indexOf(96) != -1) {
            buff = new StringBuffer();
            for (i = 0; i < tableName.length(); ++i) {
                c = tableName.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                buff.append(c);
            }
            adjustedTableName = buff.toString();
        }
        buff = new StringBuffer();
        for (i = 0; i < key.length(); ++i) {
            c = key.charAt(i);
            if (c == ' ' || c == '\"' || c == '`') continue;
            buff.append(c);
        }
        String adjustedFieldName = buff.toString();
        String indexName = startDelimiter + "IX_" + adjustedTableName + "_" + adjustedFieldName + endDelimiter;
        if (indexName.length() > maximumNameLength && (indexName = startDelimiter + adjustedTableName + "_" + adjustedFieldName + endDelimiter).length() > maximumNameLength && (indexName = startDelimiter + Helper.removeAllButAlphaNumericToFit(adjustedTableName + adjustedFieldName, maximumNameLength) + endDelimiter).length() > maximumNameLength) {
            String onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(adjustedTableName, 0);
            String onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(adjustedFieldName, 0);
            indexName = startDelimiter + Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName, onlyAlphaNumericFieldName, maximumNameLength) + endDelimiter;
            if (indexName.length() > maximumNameLength) {
                String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
                String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
                int delimiterLength = startDelimiter.length() + endDelimiter.length();
                indexName = shortenedFieldName.length() + delimiterLength >= maximumNameLength ? startDelimiter + Helper.truncate(shortenedFieldName, maximumNameLength - delimiterLength) + endDelimiter : startDelimiter + Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length() - delimiterLength) + shortenedFieldName + endDelimiter;
            }
        }
        return indexName;
    }

    @Override
    public Object clone() {
        TableDefinition clone = (TableDefinition)super.clone();
        if (this.fields != null) {
            clone.setFields(new Vector<FieldDefinition>(this.fields.size()));
            Enumeration<FieldDefinition> enumtr = this.getFields().elements();
            while (enumtr.hasMoreElements()) {
                FieldDefinition fieldDef = enumtr.nextElement();
                clone.addField((FieldDefinition)fieldDef.clone());
            }
        }
        if (this.foreignKeyMap != null) {
            clone.setForeignKeyMap((HashMap)this.foreignKeyMap.clone());
        }
        if (this.uniqueKeys != null) {
            clone.setUniqueKeys((Vector)this.uniqueKeys.clone());
        }
        return clone;
    }

    public void createConstraints(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        this.createUniqueConstraints(session, schemaWriter);
        this.createForeignConstraints(session, schemaWriter);
    }

    void createUniqueConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createUniqueConstraintsOnDatabase(session);
            return;
        }
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty() || session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            this.buildUniqueConstraintCreationWriter(session, uniqueKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    void createForeignConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createForeignConstraintsOnDatabase(session);
            return;
        }
        if (session.getPlatform().supportsForeignKeyConstraints()) {
            for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
                this.buildConstraintCreationWriter(session, foreignKey, schemaWriter).toString();
                try {
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
                catch (IOException exception) {
                    throw ValidationException.fileError(exception);
                }
            }
        }
    }

    public void createConstraintsOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.createUniqueConstraintsOnDatabase(session);
        this.createForeignConstraintsOnDatabase(session);
    }

    void createUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty() || session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintCreationWriter(session, uniqueKey, new StringWriter()).toString()));
        }
    }

    void createForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            session.executeNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(session, foreignKey, new StringWriter()).toString()));
        }
    }

    public void createIndexOnPrimaryKey(AbstractSession session, Writer schemaWriter) {
        Vector<String> primKeyList;
        if (schemaWriter == null) {
            this.createIndexOnPrimaryKeyOnDatabase(session);
            return;
        }
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() && !(primKeyList = this.getPrimaryKeyFieldNames()).isEmpty()) {
            this.buildIndexCreationWriter(session, (String)primKeyList.get(0), primKeyList, schemaWriter);
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public void createIndicesOnUniqueKeys(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.createIndicesOnUniqueKeysOnDatabase(session);
            return;
        }
        try {
            for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
                this.buildIndexCreationWriter(session, uniqueKey.getName(), uniqueKey.getSourceFields(), schemaWriter);
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            for (FieldDefinition field : this.getFields()) {
                if (!field.isUnique()) continue;
                ArrayList<String> columnAsList = new ArrayList<String>();
                columnAsList.add(field.getName());
                this.buildIndexCreationWriter(session, field.getName(), columnAsList, new StringWriter());
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void createIndexOnPrimaryKeyOnDatabase(AbstractSession session) {
        Vector<String> primKeyList;
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() && !(primKeyList = this.getPrimaryKeyFieldNames()).isEmpty()) {
            session.executeNonSelectingCall(new SQLCall(this.buildIndexCreationWriter(session, (String)primKeyList.get(0), primKeyList, new StringWriter()).toString()));
        }
    }

    public void createIndicesOnUniqueKeysOnDatabase(AbstractSession session) {
        if (!session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            return;
        }
        for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
            session.executeNonSelectingCall(new SQLCall(this.buildIndexCreationWriter(session, uniqueKey.getName(), uniqueKey.getSourceFields(), new StringWriter()).toString()));
        }
        for (FieldDefinition field : this.getFields()) {
            if (!field.isUnique()) continue;
            ArrayList<String> columnAsList = new ArrayList<String>();
            columnAsList.add(field.getName());
            session.executeNonSelectingCall(new SQLCall(this.buildIndexCreationWriter(session, field.getName(), columnAsList, new StringWriter()).toString()));
        }
    }

    @Override
    public void createOnDatabase(AbstractSession session) throws EclipseLinkException {
        super.createOnDatabase(session);
        this.createIndexOnPrimaryKeyOnDatabase(session);
        this.createIndicesOnUniqueKeysOnDatabase(session);
    }

    public String deletionStringFor(DatabaseAccessor accessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropConstraintsOnDatabase(session);
        } else {
            if (session.getPlatform().supportsForeignKeyConstraints()) {
                for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
                    this.buildConstraintDeletionWriter(session, foreignKey, schemaWriter).toString();
                    try {
                        if (this.createSQLFiles) {
                            schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                        }
                        schemaWriter.write("\n");
                    }
                    catch (IOException exception) {
                        throw ValidationException.fileError(exception);
                    }
                }
            }
            if (session.getPlatform().supportsUniqueKeyConstraints() && !session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
                Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
                while (uniqueKeysEnum.hasMoreElements()) {
                    UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
                    this.buildUniqueConstraintDeletionWriter(session, uniqueKey, schemaWriter).toString();
                    try {
                        if (this.createSQLFiles) {
                            schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                        }
                        schemaWriter.write("\n");
                    }
                    catch (IOException exception) {
                        throw ValidationException.fileError(exception);
                    }
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.dropForeignConstraintsOnDatabase(session);
        this.dropUniqueConstraintsOnDatabase(session);
    }

    private void dropUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty() || session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintDeletionWriter(session, uniqueKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    private void dropForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(session, foreignKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    @Override
    public void dropFromDatabase(AbstractSession session) throws EclipseLinkException {
        this.dropIndicesOnUniqueKeysOnDatabase(session);
        this.dropIndexOnPrimaryKeyOnDatabase(session);
        super.dropFromDatabase(session);
    }

    public void dropIndexOnPrimaryKey(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropIndexOnPrimaryKeyOnDatabase(session);
        } else if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() && !this.getPrimaryKeyFieldNames().isEmpty()) {
            try {
                this.buildIndexDeletionWriter(session, this.getPrimaryKeyFieldNames().firstElement(), schemaWriter);
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public void dropIndicesOnUniqueKeys(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropIndicesOnUniqueKeysOnDatabase(session);
        } else if (session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            try {
                for (UniqueKeyConstraint key : this.getUniqueKeys()) {
                    this.buildIndexDeletionWriter(session, key.getName(), schemaWriter);
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
                for (FieldDefinition field : this.getFields()) {
                    if (!field.isUnique()) continue;
                    this.buildIndexDeletionWriter(session, field.getName(), schemaWriter);
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public void dropIndexOnPrimaryKeyOnDatabase(AbstractSession session) throws EclipseLinkException {
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() && !this.getPrimaryKeyFieldNames().isEmpty()) {
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildIndexDeletionWriter(session, this.getPrimaryKeyFieldNames().firstElement(), new StringWriter()).toString()));
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public void dropIndicesOnUniqueKeysOnDatabase(AbstractSession session) throws EclipseLinkException {
        if (session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            for (UniqueKeyConstraint key : this.getUniqueKeys()) {
                try {
                    session.executeNonSelectingCall(new SQLCall(this.buildIndexDeletionWriter(session, key.getName(), new StringWriter()).toString()));
                }
                catch (DatabaseException ex) {}
            }
            for (FieldDefinition field : this.getFields()) {
                if (!field.isUnique()) continue;
                try {
                    session.executeNonSelectingCall(new SQLCall(this.buildIndexDeletionWriter(session, field.getName(), new StringWriter()).toString()));
                }
                catch (DatabaseException ex) {}
            }
        }
    }

    @Override
    public void dropObject(AbstractSession session, Writer schemaWriter, boolean createSQLFiles) throws EclipseLinkException {
        this.setCreateSQLFiles(createSQLFiles);
        this.dropIndicesOnUniqueKeys(session, schemaWriter);
        this.dropIndexOnPrimaryKey(session, schemaWriter);
        super.dropObject(session, schemaWriter, createSQLFiles);
    }

    HashMap<String, ForeignKeyConstraint> getForeignKeyMap() {
        return this.foreignKeyMap;
    }

    void setForeignKeyMap(HashMap<String, ForeignKeyConstraint> foreignKeyMap) {
        this.foreignKeyMap = foreignKeyMap;
    }

    public Vector<FieldDefinition> getFields() {
        return this.fields;
    }

    public Vector<ForeignKeyConstraint> getForeignKeys() {
        return new Vector<ForeignKeyConstraint>(this.foreignKeyMap.values());
    }

    public Vector<UniqueKeyConstraint> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Vector<String> getPrimaryKeyFieldNames() {
        Vector<String> keyNames = new Vector<String>();
        Enumeration<FieldDefinition> fieldEnum = this.getFields().elements();
        while (fieldEnum.hasMoreElements()) {
            FieldDefinition field = fieldEnum.nextElement();
            if (!field.isPrimaryKey()) continue;
            keyNames.addElement(field.getName());
        }
        return keyNames;
    }

    @Override
    public void postCreateObject(AbstractSession session, Writer createSchemaWriter, boolean createSQLFiles) {
        this.setCreateSQLFiles(createSQLFiles);
        this.createIndexOnPrimaryKey(session, createSchemaWriter);
        this.createIndicesOnUniqueKeys(session, createSchemaWriter);
    }

    public void setFields(Vector<FieldDefinition> fields) {
        this.fields = fields;
    }

    public void setForeignKeys(Vector<ForeignKeyConstraint> foreignKeys) {
        this.foreignKeyMap.clear();
        if (foreignKeys != null) {
            for (ForeignKeyConstraint foreignKey : foreignKeys) {
                this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
            }
        }
    }

    public void setUniqueKeys(Vector<UniqueKeyConstraint> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }
}

