/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.CompressorIterator;
import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.Decompressor;
import com.sun.java.help.search.RoleFiller;

class ConceptGroupGenerator
implements CompressorIterator {
    private static final int NConceptsInGroup = 16;
    private static final int BitsInLabel = 4;
    private int _last;
    private ConceptData[] _table;
    private Decompressor _bits;
    private int _k1;
    private final int _k2 = 4;
    private ConceptData _cData;

    public ConceptGroupGenerator() {
        this._k1 = 0;
        this._table = new ConceptData[16];
        this._last = 0;
        this._bits = null;
    }

    public ConceptGroupGenerator(byte[] bytes, int index, int k) {
        this._k1 = k;
        this._table = new ConceptData[16];
        this._last = 0;
        this._bits = new ByteArrayDecompressor(bytes, index);
    }

    public void init(byte[] bytes, int index, int k) {
        this._k1 = k;
        this._bits = new ByteArrayDecompressor(bytes, index);
        this._last = 0;
        for (int i = 0; i < 16; ++i) {
            this._table[i] = null;
        }
    }

    public void addTerms(int index, ConceptData terms) {
        this._table[index] = terms;
    }

    public int decodeConcepts(int k, int shift, int[] concepts) throws Exception {
        return this._bits.ascendingDecode(k, shift, concepts);
    }

    public int position() {
        return this._last;
    }

    public void value(int value) {
        this._last += value;
    }

    boolean next() throws Exception {
        try {
            while (this._bits.readNext(this._k1, this)) {
                this._cData = this._table[this._bits.read(4)];
                if (this._cData == null) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(this._bits);
            System.err.println(this._table);
            throw e;
        }
    }

    public void generateFillers(RoleFiller[] array) {
        this._cData.generateFillers(array, this._last);
    }
}

