/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class LiteMorph {
    protected static Vector variants;
    protected static Hashtable rulesTable;
    protected static Hashtable blockedVariants;
    protected static Hashtable exceptions;
    private static final boolean debugFlag = false;

    public LiteMorph() {
        this.initialize();
    }

    public static LiteMorph getMorph() {
        return null;
    }

    protected abstract void initialize();

    protected void initialize(String[] exceptionTable) {
        if (exceptions == null || exceptionTable == null) {
            return;
        }
        for (int i = 0; i < exceptionTable.length; ++i) {
            StringTokenizer tokens = new StringTokenizer(exceptionTable[i], " ");
            while (tokens.hasMoreTokens()) {
                String tempWord = tokens.nextToken();
                String tempVal = (String)exceptions.get(tempWord);
                if (tempVal == null) {
                    exceptions.put(tempWord, exceptionTable[i]);
                    continue;
                }
                exceptions.put(tempWord, tempVal + " " + exceptionTable[i]);
            }
        }
    }

    public synchronized String[] variantsOf(String word) {
        variants = new Vector();
        blockedVariants = new Hashtable();
        blockedVariants.put(word, word);
        this.morphWord(word, 0);
        blockedVariants = null;
        Object[] result = new String[variants.size()];
        variants.copyInto(result);
        variants = null;
        return result;
    }

    protected void morphWord(String word, int depth) {
        LiteMorph.debug(" analyzing: " + word + " at depth " + depth);
        if (depth > 2) {
            return;
        }
        String exceptionList = (String)exceptions.get(word);
        if (exceptionList == null) {
            exceptionList = "";
        }
        if (exceptionList.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(exceptionList, " ");
            while (tokens.hasMoreTokens()) {
                this.addVariant(tokens.nextToken());
            }
            LiteMorph.debug("   " + word + ": found match in exceptions -- " + exceptionList + ", at depth " + depth);
            return;
        }
        if (word.indexOf("-") >= 0) {
            return;
        }
        Rule[] rules = null;
        int skipnum = 0;
        Enumeration keys = rulesTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!word.endsWith(key) || key.equals("default")) continue;
            rules = (Rule[])rulesTable.get(key);
            skipnum = key.length();
            break;
        }
        if (rules == null) {
            rules = (Rule[])rulesTable.get("default");
            skipnum = 0;
        }
        for (int i = 0; i < rules.length; ++i) {
            LiteMorph.debug("  " + word + ": trying rule: " + rules[i] + ", at depth " + depth);
            String[] results = rules[i].match(word, depth, skipnum);
            if (results.length <= 0) continue;
            LiteMorph.debug("  " + word + ": found match for: " + rules[i] + ", at depth " + depth);
            this.addVariant(word);
            for (int j = 0; j < results.length; ++j) {
                this.addVariant(results[j]);
            }
            break;
        }
    }

    private void addVariant(String word) {
        if (blockedVariants.get(word) == null) {
            variants.addElement(word);
            blockedVariants.put(word, word);
        }
    }

    protected static Rule r(String expression, String expansions, LiteMorph morph) {
        return new Rule(expression, expansions, morph);
    }

    private static void debug(String str) {
    }
}

