/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.NextDocGenerator;

class NextDocGeneratorHeap {
    private static final int InitSize = 1024;
    private int _heapSize = 0;
    private int _size = 1024;
    private NextDocGenerator[] _heap = new NextDocGenerator[1024];
    private int _free = 0;
    private boolean _nonEmpty = false;

    NextDocGeneratorHeap() {
    }

    public boolean isNonEmpty() {
        return this._nonEmpty;
    }

    public void addGenerator(NextDocGenerator gen) {
        if (this._free == this._size) {
            NextDocGenerator[] newArray = new NextDocGenerator[this._size *= 2];
            System.arraycopy(this._heap, 0, newArray, 0, this._free);
            this._heap = newArray;
        }
        this._heap[this._free++] = gen;
    }

    public void start() {
        this._heapSize = this._free;
        if (this._heapSize > 0) {
            for (int i = this._heapSize / 2; i >= 0; --i) {
                this.heapify(i);
            }
            this._nonEmpty = true;
        } else {
            this._nonEmpty = false;
        }
    }

    public void step() throws Exception {
        if (this._heap[0].next() != -1) {
            this.heapify(0);
        } else if (this._heapSize > 1) {
            this._heap[0] = this._heap[--this._heapSize];
            this.heapify(0);
        } else {
            this._nonEmpty = false;
        }
    }

    public int getDocument() {
        return this._heap[0].getDocument();
    }

    public int getConcept() {
        return this._heap[0].getConcept();
    }

    public ConceptData getTerms() {
        return this._heap[0].getTerms();
    }

    public int getQueryMask() {
        return this._heap[0].getQueryMask();
    }

    public void reset() {
        this._nonEmpty = false;
        this._free = 0;
    }

    public boolean atDocument(int document) {
        return this._nonEmpty && this._heap[0].getDocument() == document;
    }

    private void heapify(int i) {
        int smallest;
        int r = i + 1 << 1;
        int l = r - 1;
        int n = smallest = l < this._heapSize && this._heap[l].smallerThan(this._heap[i]) ? l : i;
        if (r < this._heapSize && this._heap[r].smallerThan(this._heap[smallest])) {
            smallest = r;
        }
        if (smallest != i) {
            NextDocGenerator temp = this._heap[smallest];
            this._heap[smallest] = this._heap[i];
            this._heap[i] = temp;
            this.heapify(smallest);
        }
    }
}

