/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.NavigatorView;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;

public class MergingSearchEngine
extends SearchEngine {
    private Vector engines;
    private Hashtable enginePerView = new Hashtable();
    private boolean stopQuery = false;
    private static final boolean debug = false;

    public MergingSearchEngine(NavigatorView view) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        this.engines = new Vector();
        SearchEngine engine = this.makeEngine(view);
        this.engines.addElement(engine);
    }

    public MergingSearchEngine(SearchEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine must not be null");
        }
        this.engines = new Vector();
        this.engines.addElement(engine);
    }

    public SearchQuery createQuery() {
        return new MergingSearchQuery(this);
    }

    public void merge(NavigatorView view) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        SearchEngine engine = this.makeEngine(view);
        if (engine == null) {
            throw new IllegalArgumentException("view is invalid");
        }
        this.engines.addElement(engine);
        this.enginePerView.put(view, engine);
    }

    public void remove(NavigatorView view) {
        if (view == null) {
            throw new IllegalArgumentException("view is either null or invalid");
        }
        SearchEngine engine = (SearchEngine)this.enginePerView.get(view);
        if (engine == null) {
            throw new IllegalArgumentException("view is either null or invalid");
        }
        this.engines.removeElement(engine);
        this.enginePerView.remove(engine);
    }

    public Enumeration getEngines() {
        return this.engines.elements();
    }

    private SearchEngine makeEngine(NavigatorView view) {
        Constructor<?> konstructor;
        Class<?> klass;
        Hashtable params = view.getParameters();
        if (params == null || params != null && !params.containsKey("data")) {
            return null;
        }
        String engineName = (String)params.get("engine");
        HelpSet hs = view.getHelpSet();
        URL base = hs.getHelpSetURL();
        ClassLoader loader = hs.getLoader();
        if (engineName == null) {
            engineName = HelpUtilities.getDefaultQueryEngine();
            params.put("engine", engineName);
        }
        SearchEngine back = null;
        Class[] types = new Class[]{URL.class, Hashtable.class};
        Object[] args = new Object[]{base, params};
        MergingSearchEngine.debug("makeEngine");
        MergingSearchEngine.debug("  base: " + base);
        MergingSearchEngine.debug("  params: " + params);
        try {
            klass = loader == null ? Class.forName(engineName) : loader.loadClass(engineName);
        }
        catch (Throwable t) {
            throw new Error("Could not load engine named " + engineName + " for view: " + view);
        }
        try {
            konstructor = klass.getConstructor(types);
        }
        catch (Throwable t) {
            throw new Error("Could not find constructor for " + engineName + ". For view: " + view);
        }
        try {
            back = (SearchEngine)konstructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            System.err.println("Exception while creating engine named " + engineName + " for view: " + view);
            e.printStackTrace();
        }
        catch (Throwable t) {
            throw new Error("Could not create engine named " + engineName + " for view: " + view);
        }
        return back;
    }

    private static void debug(String msg) {
    }

    private class MergingSearchQuery
    extends SearchQuery
    implements SearchListener {
        private MergingSearchEngine mhs;
        private Vector queries;
        private String searchparams;

        public MergingSearchQuery(SearchEngine hs) {
            super(hs);
            if (hs instanceof MergingSearchEngine) {
                this.mhs = (MergingSearchEngine)hs;
            }
        }

        public synchronized void start(String searchparams, Locale l) throws IllegalArgumentException, IllegalStateException {
            MergingSearchEngine.debug("startSearch()");
            if (this.isActive()) {
                throw new IllegalStateException();
            }
            MergingSearchEngine.this.stopQuery = false;
            super.start(searchparams, l);
            this.queries = new Vector();
            Enumeration e = this.mhs.getEngines();
            while (e.hasMoreElements()) {
                SearchEngine engine = (SearchEngine)e.nextElement();
                if (engine == null) continue;
                this.queries.addElement(engine.createQuery());
            }
            e = this.queries.elements();
            while (e.hasMoreElements()) {
                SearchQuery query = (SearchQuery)e.nextElement();
                query.addSearchListener(this);
                query.start(searchparams, l);
            }
        }

        public synchronized void stop() throws IllegalStateException {
            if (this.queries == null) {
                return;
            }
            MergingSearchEngine.this.stopQuery = true;
            boolean queriesActive = true;
            while (queriesActive) {
                queriesActive = false;
                if (this.queries == null) continue;
                Enumeration e = this.queries.elements();
                while (e.hasMoreElements()) {
                    SearchQuery query = (SearchQuery)e.nextElement();
                    if (!query.isActive()) continue;
                    MergingSearchEngine.debug("queries are active waiting to stop");
                    queriesActive = true;
                }
                if (!queriesActive) continue;
                try {
                    this.wait(250L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.queries = null;
        }

        public boolean isActive() {
            if (this.queries == null) {
                return false;
            }
            Enumeration e = this.queries.elements();
            while (e.hasMoreElements()) {
                SearchQuery query = (SearchQuery)e.nextElement();
                if (!query.isActive()) continue;
                return true;
            }
            return false;
        }

        public SearchEngine getSearchEngine() {
            return this.mhs;
        }

        public synchronized void itemsFound(SearchEvent e) {
            SearchQuery queryin = (SearchQuery)e.getSource();
            if (MergingSearchEngine.this.stopQuery) {
                return;
            }
            if (this.queries != null) {
                Enumeration enum1 = this.queries.elements();
                while (enum1.hasMoreElements()) {
                    SearchQuery query = (SearchQuery)enum1.nextElement();
                    if (query != queryin) continue;
                    this.fireItemsFound(e);
                }
            }
        }

        public void searchStarted(SearchEvent e) {
        }

        public synchronized void searchFinished(SearchEvent e) {
            SearchQuery queryin = (SearchQuery)e.getSource();
            if (this.queries != null) {
                Enumeration enum1 = this.queries.elements();
                while (enum1.hasMoreElements()) {
                    SearchQuery query = (SearchQuery)enum1.nextElement();
                    if (query != queryin) continue;
                    queryin.removeSearchListener(this);
                    this.queries.removeElement(query);
                }
                if (this.queries.isEmpty()) {
                    this.queries = null;
                    if (!MergingSearchEngine.this.stopQuery) {
                        this.fireSearchFinished();
                    }
                }
            }
        }
    }
}

