/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.agent;

import com.sun.btrace.BTraceRuntime;
import com.sun.btrace.CommandListener;
import com.sun.btrace.PerfReader;
import com.sun.btrace.RunnableGenerator;
import com.sun.btrace.agent.Main;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.comm.InstrumentCommand;
import com.sun.btrace.comm.OkayCommand;
import com.sun.btrace.comm.RenameCommand;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.runtime.ClassFilter;
import com.sun.btrace.runtime.ClassRenamer;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.Instrumentor;
import com.sun.btrace.runtime.MethodRemover;
import com.sun.btrace.runtime.NullPerfReaderImpl;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.OnProbe;
import com.sun.btrace.runtime.Preprocessor;
import com.sun.btrace.runtime.RunnableGeneratorImpl;
import com.sun.btrace.runtime.Verifier;
import com.sun.btrace.util.NullVisitor;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.List;

abstract class Client
implements ClassFileTransformer,
CommandListener {
    protected final Instrumentation inst;
    private volatile BTraceRuntime runtime;
    private volatile String className;
    private volatile Class btraceClazz;
    private volatile byte[] btraceCode;
    private volatile List<OnMethod> onMethods;
    private volatile List<OnProbe> onProbes;
    private volatile ClassFilter filter;
    private volatile boolean skipRetransforms;
    protected final boolean debug = Main.isDebug();
    private static long count;

    private static PerfReader createPerfReaderImpl() {
        try {
            Class.forName("sun.jvmstat.monitor.MonitoredHost");
            return (PerfReader)Class.forName("com.sun.btrace.runtime.PerfReaderImpl").newInstance();
        }
        catch (Exception exp) {
            return new NullPerfReaderImpl();
        }
    }

    Client(Instrumentation inst) {
        this.inst = inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String cname, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean entered = BTraceRuntime.enter();
        try {
            if (Client.isBTraceClass(cname) || Client.isSensitiveClass(cname)) {
                if (this.debug) {
                    Main.debugPrint("skipping transform for BTrace class " + cname);
                }
                byte[] byArray = null;
                return byArray;
            }
            if (classBeingRedefined != null && !this.skipRetransforms && this.filter.isCandidate(classBeingRedefined)) {
                if (this.debug) {
                    Main.debugPrint("client " + this.className + ": instrumenting " + cname);
                }
                byte[] byArray = this.instrument(classBeingRedefined, cname, classfileBuffer);
                return byArray;
            }
            if (this.filter.isCandidate(classfileBuffer)) {
                if (this.debug) {
                    Main.debugPrint("client " + this.className + ": instrumenting " + cname);
                }
                byte[] byArray = this.instrument(classBeingRedefined, cname, classfileBuffer);
                return byArray;
            }
            if (this.debug) {
                Main.debugPrint("client " + this.className + ": skipping transform for " + cname);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (entered) {
                BTraceRuntime.leave();
            }
        }
    }

    protected synchronized void onExit(int exitCode) {
        block6: {
            if (this.shouldAddTransformer()) {
                if (this.debug) {
                    Main.debugPrint("onExit: removing transformer for " + this.className);
                }
                this.inst.removeTransformer(this);
            }
            try {
                if (this.debug) {
                    Main.debugPrint("onExit: closing all");
                }
                Thread.sleep(300L);
                this.closeAll();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException ioexp) {
                if (!this.debug) break block6;
                Main.debugPrint(ioexp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(InstrumentCommand instr) throws IOException {
        String[] args = instr.getArguments();
        this.btraceCode = instr.getCode();
        try {
            this.verify(this.btraceCode);
        }
        catch (Throwable th) {
            if (this.debug) {
                Main.debugPrint(th);
            }
            this.errorExit(th);
            return null;
        }
        this.filter = new ClassFilter(this.onMethods);
        if (this.debug) {
            Main.debugPrint("created class filter");
        }
        ClassWriter writer = InstrumentUtils.newClassWriter(this.btraceCode);
        ClassReader reader = new ClassReader(this.btraceCode);
        ClassAdapter visitor = new Preprocessor(writer);
        if (BTraceRuntime.classNameExists((String)this.className)) {
            this.className = this.className + "$" + Client.getCount();
            if (this.debug) {
                Main.debugPrint("class renamed to " + this.className);
            }
            this.onCommand((Command)new RenameCommand(this.className));
            visitor = new ClassRenamer(this.className, visitor);
        }
        try {
            if (this.debug) {
                Main.debugPrint("preprocessing BTrace class " + this.className);
            }
            InstrumentUtils.accept(reader, visitor);
            if (this.debug) {
                Main.debugPrint("preprocessed BTrace class " + this.className);
            }
            this.btraceCode = writer.toByteArray();
        }
        catch (Throwable th) {
            if (this.debug) {
                Main.debugPrint(th);
            }
            this.errorExit(th);
            return null;
        }
        Main.dumpClass(this.className, this.className, this.btraceCode);
        if (this.debug) {
            Main.debugPrint("creating BTraceRuntime instance for " + this.className);
        }
        this.runtime = new BTraceRuntime(this.className, args, (CommandListener)this, this.inst);
        if (this.debug) {
            Main.debugPrint("created BTraceRuntime instance for " + this.className);
        }
        if (this.debug) {
            Main.debugPrint("removing @OnMethod, @OnProbe methods");
        }
        byte[] codeBuf = Client.removeMethods(this.btraceCode);
        if (this.debug) {
            Main.debugPrint("removed @OnMethod, @OnProbe methods");
        }
        if (this.debug) {
            Main.debugPrint("sending Okay command");
        }
        this.onCommand((Command)new OkayCommand());
        boolean enteredHere = BTraceRuntime.enter();
        try {
            BTraceRuntime.leave();
            if (this.debug) {
                Main.debugPrint("about to defineClass " + this.className);
            }
            this.btraceClazz = this.shouldAddTransformer() ? this.runtime.defineClass(codeBuf) : this.runtime.defineClass(codeBuf, false);
            if (this.debug) {
                Main.debugPrint("defineClass succeeded for " + this.className);
            }
        }
        catch (Throwable th) {
            if (this.debug) {
                Main.debugPrint(th);
            }
            this.errorExit(th);
            Class clazz = null;
            return clazz;
        }
        finally {
            if (!enteredHere) {
                BTraceRuntime.enter();
            }
        }
        return this.btraceClazz;
    }

    protected abstract void closeAll() throws IOException;

    protected void errorExit(Throwable th) throws IOException {
        if (this.debug) {
            Main.debugPrint("sending error command");
        }
        this.onCommand((Command)new ErrorCommand(th));
        if (this.debug) {
            Main.debugPrint("sending exit command");
        }
        this.onCommand((Command)new ExitCommand(1));
        this.closeAll();
    }

    final BTraceRuntime getRuntime() {
        return this.runtime;
    }

    final String getClassName() {
        return this.className;
    }

    final Class getBTraceClass() {
        return this.btraceClazz;
    }

    final boolean isCandidate(Class c) {
        String cname = c.getName().replace('.', '/');
        if (c.isInterface() || c.isPrimitive() || c.isArray()) {
            return false;
        }
        if (Client.isBTraceClass(cname)) {
            return false;
        }
        return this.filter.isCandidate(c);
    }

    final boolean shouldAddTransformer() {
        return this.onMethods != null && this.onMethods.size() > 0;
    }

    final void skipRetransforms() {
        this.skipRetransforms = true;
    }

    private static boolean isBTraceClass(String name) {
        return name.startsWith("com/sun/btrace/");
    }

    private static boolean isSensitiveClass(String name) {
        return name.equals("java/lang/Object") || name.startsWith("java/lang/ThreadLocal") || name.startsWith("sun/reflect");
    }

    private byte[] instrument(Class clazz, String cname, byte[] target) {
        byte[] instrumentedCode;
        try {
            ClassWriter writer = InstrumentUtils.newClassWriter(target);
            ClassReader reader = new ClassReader(target);
            InstrumentUtils.accept(reader, new Instrumentor(clazz, this.className, this.btraceCode, this.onMethods, (ClassVisitor)writer));
            instrumentedCode = writer.toByteArray();
        }
        catch (Throwable th) {
            Main.debugPrint(th);
            return null;
        }
        Main.dumpClass(this.className, cname, instrumentedCode);
        return instrumentedCode;
    }

    private void verify(byte[] buf) {
        ClassReader reader = new ClassReader(buf);
        Verifier verifier = new Verifier(new NullVisitor(), Main.isUnsafe());
        if (this.debug) {
            Main.debugPrint("verifying BTrace class");
        }
        InstrumentUtils.accept(reader, verifier);
        this.className = verifier.getClassName().replace('/', '.');
        if (this.debug) {
            Main.debugPrint("verified '" + this.className + "' successfully");
        }
        this.onMethods = verifier.getOnMethods();
        this.onProbes = verifier.getOnProbes();
        if (this.onProbes != null && !this.onProbes.isEmpty()) {
            this.onMethods.addAll(Main.mapOnProbes(this.onProbes));
        }
    }

    private static byte[] removeMethods(byte[] buf) {
        ClassWriter writer = InstrumentUtils.newClassWriter(buf);
        ClassReader reader = new ClassReader(buf);
        InstrumentUtils.accept(reader, new MethodRemover(writer));
        return writer.toByteArray();
    }

    private static long getCount() {
        return count++;
    }

    static {
        ClassFilter.class.getClass();
        InstrumentUtils.class.getClass();
        Instrumentor.class.getClass();
        ClassReader.class.getClass();
        ClassWriter.class.getClass();
        BTraceRuntime.init((PerfReader)Client.createPerfReaderImpl(), (RunnableGenerator)new RunnableGeneratorImpl());
        count = 0L;
    }
}

