/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transaction;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.jasper.servlet.JspServlet;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.ServerContext;

public final class J2EEInstanceListener
implements InstanceListener {
    protected static final Logger _logger = LogDomains.getLogger(J2EEInstanceListener.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    private InvocationManager im;
    private JavaEETransactionManager tm;
    private InjectionManager injectionMgr;
    private boolean initialized = false;
    private AppServSecurityContext securityContext;
    private static AuthPermission doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");

    public void instanceEvent(InstanceEvent event) {
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule wm = (WebModule)context;
        this.init(wm);
        InstanceEvent.EventType eventType = event.getType();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "*** InstanceEvent: " + eventType);
        }
        if (eventType.isBefore) {
            this.handleBeforeEvent(event, eventType);
        } else {
            this.handleAfterEvent(event, eventType);
        }
    }

    private synchronized void init(WebModule wm) {
        if (this.initialized) {
            return;
        }
        ServerContext serverContext = wm.getServerContext();
        if (serverContext == null) {
            String msg = _rb.getString("webmodule.noservercontext");
            msg = MessageFormat.format(msg, wm.getName());
            throw new IllegalStateException(msg);
        }
        this.im = (InvocationManager)serverContext.getDefaultHabitat().getByContract(InvocationManager.class);
        this.tm = (JavaEETransactionManager)serverContext.getDefaultHabitat().getByContract(JavaEETransactionManager.class);
        this.injectionMgr = (InjectionManager)serverContext.getDefaultHabitat().getByContract(InjectionManager.class);
        this.initialized = true;
        this.securityContext = (AppServSecurityContext)serverContext.getDefaultHabitat().getByContract(AppServSecurityContext.class);
        if (this.securityContext != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Obtained securityContext implementation class " + this.securityContext);
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Failed to obtain securityContext implementation class ");
        }
    }

    private void handleBeforeEvent(InstanceEvent event, InstanceEvent.EventType eventType) {
        ServletRequest request;
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule wm = (WebModule)context;
        Object instance = eventType == InstanceEvent.EventType.BEFORE_FILTER_EVENT ? event.getFilter() : event.getServlet();
        Realm ra = context.getRealm();
        if (ra != null && (request = event.getRequest()) != null && request instanceof HttpServletRequest) {
            Principal prin;
            HttpServletRequest hreq;
            HttpServletRequest base = hreq = (HttpServletRequest)request;
            Principal basePrincipal = prin = hreq.getUserPrincipal();
            boolean wrapped = false;
            while (prin != null) {
                ServletRequest sr;
                if (base instanceof ServletRequestWrapper && (sr = ((ServletRequestWrapper)((Object)base)).getRequest()) instanceof HttpServletRequest) {
                    base = (HttpServletRequest)sr;
                    wrapped = true;
                    continue;
                }
                if (wrapped) {
                    basePrincipal = base.getUserPrincipal();
                    break;
                }
                if (base instanceof RequestFacade) {
                    if (base.getClass() == RequestFacade.class) break;
                    basePrincipal = ((RequestFacade)base).getUnwrappedCoyoteRequest().getUserPrincipal();
                    break;
                }
                basePrincipal = base.getUserPrincipal();
                break;
            }
            if (prin != null && prin == basePrincipal && prin.getClass().getName().equals("com.sun.enterprise.security.web.integration.WebPrincipal")) {
                this.securityContext.setSecurityContextWithPrincipal(prin);
            } else if (prin != basePrincipal) {
                J2EEInstanceListener.checkObjectForDoAsPermission(hreq);
                this.securityContext.setSecurityContextWithPrincipal(prin);
            }
        }
        WebComponentInvocation inv = new WebComponentInvocation(wm, instance);
        try {
            this.im.preInvoke((ComponentInvocation)inv);
            if (eventType == InstanceEvent.EventType.BEFORE_SERVICE_EVENT) {
                wm.beforeServiceEvent(event.getWrapper().getName());
                Transaction tran = this.tm.getTransaction();
                if (tran != null) {
                    inv.setTransaction(tran);
                }
                this.tm.enlistComponentResources();
            }
        }
        catch (Exception ex) {
            String message = _rb.getString("web_server.excep_handle_before_event");
            throw new RuntimeException(message, ex);
        }
    }

    private static void checkObjectForDoAsPermission(final Object o) throws AccessControlException {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ProtectionDomain pD = o.getClass().getProtectionDomain();
                    Policy p = Policy.getPolicy();
                    if (!p.implies(pD, doAsPrivilegedPerm)) {
                        throw new AccessControlException("permission required to override getUserPrincipal", doAsPrivilegedPerm);
                    }
                    return null;
                }
            });
        }
    }

    /*
     * Loose catch block
     */
    private void handleAfterEvent(InstanceEvent event, InstanceEvent.EventType eventType) {
        block34: {
            WebComponentInvocation inv;
            Object instance;
            WebModule wm;
            Context context;
            Wrapper wrapper;
            block31: {
                wrapper = event.getWrapper();
                context = (Context)wrapper.getParent();
                if (!(context instanceof WebModule)) {
                    return;
                }
                wm = (WebModule)context;
                instance = eventType == InstanceEvent.EventType.AFTER_FILTER_EVENT ? event.getFilter() : event.getServlet();
                if (instance instanceof Servlet) {
                    if (eventType == InstanceEvent.EventType.AFTER_INIT_EVENT) {
                        wm.servletInitializedEvent(wrapper.getName());
                    } else if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT) {
                        wm.servletDestroyedEvent(wrapper.getName());
                    }
                }
                try {
                    if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT && !DefaultServlet.class.equals(instance.getClass()) && !JspServlet.class.equals(instance.getClass())) {
                        this.injectionMgr.destroyManagedObject(instance);
                    }
                }
                catch (InjectionException ie) {
                    _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ie);
                }
                inv = new WebComponentInvocation(wm, instance);
                try {
                    this.im.postInvoke((ComponentInvocation)inv);
                    Object var10_9 = null;
                    if (eventType != InstanceEvent.EventType.AFTER_DESTROY_EVENT) break block31;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT) {
                        this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                    } else if (eventType == InstanceEvent.EventType.AFTER_FILTER_EVENT || eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
                        if (eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
                            ServletResponse response = event.getResponse();
                            int status = -1;
                            if (response != null && response instanceof HttpServletResponse) {
                                status = ((HttpServletResponse)response).getStatus();
                            }
                            wm.afterServiceEvent(wrapper.getName(), status);
                        }
                        if (this.im.getCurrentInvocation() == null) {
                            try {
                                Realm ra = context.getRealm();
                                if (ra != null && ra instanceof RealmInitializer) {
                                    this.securityContext.setCurrentSecurityContext(null);
                                }
                            }
                            catch (Exception ex) {
                                _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex);
                            }
                            try {
                                if (this.tm.getTransaction() != null) {
                                    this.tm.rollback();
                                }
                                this.tm.cleanTxnTimeout();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                    }
                    throw throwable;
                }
                this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                break block34;
            }
            if (eventType != InstanceEvent.EventType.AFTER_FILTER_EVENT && eventType != InstanceEvent.EventType.AFTER_SERVICE_EVENT) break block34;
            if (eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
                ServletResponse response = event.getResponse();
                int status = -1;
                if (response != null && response instanceof HttpServletResponse) {
                    status = ((HttpServletResponse)response).getStatus();
                }
                wm.afterServiceEvent(wrapper.getName(), status);
            }
            if (this.im.getCurrentInvocation() == null) {
                try {
                    Realm ra = context.getRealm();
                    if (ra != null && ra instanceof RealmInitializer) {
                        this.securityContext.setCurrentSecurityContext(null);
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex);
                }
                try {
                    if (this.tm.getTransaction() != null) {
                        this.tm.rollback();
                    }
                    this.tm.cleanTxnTimeout();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
            {
                break block34;
                catch (Exception ex) {
                    throw new RuntimeException(_rb.getString("web_server.excep_handle_after_event"), ex);
                }
            }
        }
    }
}

