/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.Service;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SMFService
implements Service {
    public static final String DATE_CREATED_TN = "DATE_CREATED";
    public static final String AS_ADMIN_PATH_TN = "AS_ADMIN_PATH";
    public static final String CREDENTIALS_TN = "CREDENTIALS";
    public static final String SERVICE_NAME_TN = "NAME";
    public static final String SERVICE_TYPE_TN = "TYPE";
    public static final String CFG_LOCATION_TN = "LOCATION";
    public static final String ENTITY_NAME_TN = "ENTITY_NAME";
    public static final String FQSN_TN = "FQSN";
    public static final String AS_ADMIN_USER_TN = "AS_ADMIN_USER";
    public static final String AS_ADMIN_PASSWORD_TN = "AS_ADMIN_PASSWORD";
    public static final String AS_ADMIN_MASTERPASSWORD_TN = "AS_ADMIN_MASTERPASSWORD";
    public static final String TIMEOUT_SECONDS_TN = "TIMEOUT_SECONDS";
    public static final String OS_USER_TN = "OS_USER";
    public static final String PRIVILEGES_TN = "PRIVILEGES";
    public static final String TIMEOUT_SECONDS_DV = "0";
    public static final String AS_ADMIN_USER_DEF_VAL = "admin";
    public static final String SP_DELIMITER = ":";
    public static final String PRIVILEGES_DEFAULT_VAL = "basic";
    public static final String NETADDR_PRIV_VAL = "net_privaddr";
    public static final String BASIC_NETADDR_PRIV_VAL = "basic,net_privaddr";
    public static final String START_INSTANCES_TN = "START_INSTANCES";
    public static final String START_INSTANCES_DEFAULT_VAL = Boolean.TRUE.toString();
    public static final String NO_START_INSTANCES_PROPERTY = "startinstances=false";
    public static final String SVCCFG = "/usr/sbin/svccfg";
    public static final String SVCADM = "/usr/sbin/svcadm";
    public static final String MANIFEST_HOME = "/var/svc/manifest/application/GlassFish/";
    private static final String NULL_VALUE = "null";
    private static final StringManager sm = StringManager.getManager(SMFService.class);
    private static final String nullArgMsg = sm.getString("null_arg");
    private static final String MANIFEST_FILE_SUFFIX = "-service-smf.xml";
    private static final String MANIFEST_FILE_TEMPL_SUFFIX = "-service-smf.xml.template";
    private static final String SERVICE_NAME_PREFIX = "application/GlassFish/";
    private static final String REL_PATH_TEMPLATES = "lib/install/templates";
    private final Map<String, String> pairs;
    private boolean trace = true;
    private boolean dryRun;
    private String shortName;

    SMFService() {
        if (!SMFService.apropos()) {
            throw new IllegalArgumentException("Internal Error: SMFService constructor called but SMF is not available.");
        }
        this.pairs = new HashMap<String, String>();
        this.init();
    }

    private SMFService(Map<String, String> tv) {
        if (tv == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        this.pairs = new HashMap<String, String>(tv);
    }

    static boolean apropos() {
        return OS.isSun() && new File(SVCADM).isFile();
    }

    @Override
    public String getName() {
        return this.pairs.get(SERVICE_NAME_TN);
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        this.shortName = name;
        String fullName = SERVICE_NAME_PREFIX + name;
        if (this.serviceNameExists(fullName)) {
            String msg = sm.getString("serviceNameExists", (Object)fullName);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(SERVICE_NAME_TN, fullName);
    }

    @Override
    public AppserverServiceType getType() {
        return AppserverServiceType.valueOf(this.pairs.get(SERVICE_TYPE_TN));
    }

    @Override
    public void setType(AppserverServiceType type) {
        this.pairs.put(SERVICE_TYPE_TN, type.toString());
    }

    @Override
    public String getDate() {
        return this.pairs.get(DATE_CREATED_TN);
    }

    @Override
    public void setDate(String date) {
        if (date == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        this.pairs.put(DATE_CREATED_TN, date);
    }

    @Override
    public String getLocation() {
        return this.pairs.get(CFG_LOCATION_TN);
    }

    @Override
    public void setLocation(String cfgLocation) {
        if (cfgLocation == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        File cf = FileUtils.safeGetCanonicalFile((File)new File(cfgLocation));
        this.pairs.put(CFG_LOCATION_TN, cf.getParent());
        this.pairs.put(ENTITY_NAME_TN, cf.getName());
    }

    @Override
    public String getFQSN() {
        return this.pairs.get(FQSN_TN);
    }

    @Override
    public void setFQSN() {
        assert (!NULL_VALUE.equals(this.pairs.get(SERVICE_NAME_TN))) : "Internal: Caller tried to call this method before setName()";
        String underscored = this.pairs.get(ENTITY_NAME_TN) + this.pairs.get(CFG_LOCATION_TN).replace('/', '_');
        this.pairs.put(FQSN_TN, underscored);
    }

    @Override
    public String getAsadminPath() {
        return this.pairs.get(AS_ADMIN_PATH_TN);
    }

    @Override
    public void setAsadminPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        if (!new File(path).exists()) {
            String msg = sm.getString("doesNotExist", (Object)path);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(AS_ADMIN_PATH_TN, path);
    }

    @Override
    public String getPasswordFilePath() {
        throw new UnsupportedOperationException("Not supported any longer.");
    }

    @Override
    public void setPasswordFilePath(String path) {
        HashMap<String, String> tv;
        if (path == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        String msg = null;
        if (!new File(path).exists()) {
            msg = sm.getString("doesNotExist", (Object)path);
            throw new IllegalArgumentException(msg);
        }
        String cp = FileUtils.safeGetCanonicalPath((File)new File(path));
        if (!this.fileContainsToken(cp, AS_ADMIN_USER_TN, tv = new HashMap<String, String>())) {
            msg = sm.getString("missingParamsInFile", (Object)cp, (Object)AS_ADMIN_USER_TN);
            throw new IllegalArgumentException(msg);
        }
        if (!this.fileContainsToken(cp, AS_ADMIN_PASSWORD_TN, tv)) {
            msg = sm.getString("missingParamsInFile", (Object)cp, (Object)AS_ADMIN_PASSWORD_TN);
            throw new IllegalArgumentException(msg);
        }
        if (!this.fileContainsToken(path, AS_ADMIN_MASTERPASSWORD_TN, tv)) {
            msg = sm.getString("missingParamsInFile", (Object)cp, (Object)AS_ADMIN_MASTERPASSWORD_TN);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(CREDENTIALS_TN, " --user " + (String)tv.get(AS_ADMIN_USER_TN) + " --passwordfile " + cp + " ");
    }

    @Override
    public int getTimeoutSeconds() {
        int to = Integer.parseInt(this.pairs.get(TIMEOUT_SECONDS_TN));
        return to;
    }

    @Override
    public void setTimeoutSeconds(int number) {
        Integer to = number;
        if (to < 0) {
            String msg = sm.getString("invalidTO", (Object)number);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(TIMEOUT_SECONDS_TN, to.toString());
    }

    @Override
    public String getOSUser() {
        return this.pairs.get(OS_USER_TN);
    }

    @Override
    public void setOSUser() {
        String user = System.getProperty("user.name");
        if (!this.canCreateManifest()) {
            String msg = sm.getString("noPermissionToCreateManifest", (Object)user, (Object)MANIFEST_HOME);
            throw new IllegalArgumentException(msg);
        }
        StringBuilder auths = new StringBuilder();
        if (!this.isUserSmfAuthorized(user, auths)) {
            String msg = sm.getString("noSmfAuth", (Object)user, (Object)auths);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(OS_USER_TN, user);
    }

    @Override
    public String getServiceProperties() {
        return this.pairs.get(PRIVILEGES_TN);
    }

    @Override
    public void setServiceProperties(String cds) {
        if (cds != null) {
            Set<String> props = this.ps2Pairs(cds);
            if (props.contains(NETADDR_PRIV_VAL)) {
                this.pairs.put(PRIVILEGES_TN, BASIC_NETADDR_PRIV_VAL);
            }
            if (props.contains(NO_START_INSTANCES_PROPERTY)) {
                this.pairs.put(START_INSTANCES_TN, Boolean.FALSE.toString());
            }
        }
    }

    @Override
    public boolean isConfigValid() {
        Set<String> keys = this.pairs.keySet();
        for (String k : keys) {
            boolean aNullValue = NULL_VALUE.equals(this.pairs.get(k));
            if (!aNullValue) continue;
            String msg = sm.getString("smfTokenNeeded", (Object)k, (Object)this.pairs.get(k));
            throw new RuntimeException(msg);
        }
        File mf = new File(this.getManifestFileTemplatePath());
        if (!mf.exists()) {
            String msg = sm.getString("serviceTemplateNotFound", (Object)this.getManifestFileTemplatePath());
            throw new RuntimeException(msg);
        }
        return true;
    }

    @Override
    public Map<String, String> tokensAndValues() {
        return new HashMap<String, String>(this.pairs);
    }

    @Override
    public String getManifestFilePath() {
        String fqsn = this.getFQSN();
        if (NULL_VALUE.equals(fqsn)) {
            String msg = sm.getString("serviceNameInvalid", (Object)fqsn);
            throw new RuntimeException(msg);
        }
        String fn = MANIFEST_HOME + fqsn + "/" + this.getType().toString() + MANIFEST_FILE_SUFFIX;
        return fn;
    }

    @Override
    public String getManifestFileTemplatePath() {
        if (NULL_VALUE.equals(this.getType().toString())) {
            String msg = sm.getString("serviceTypeNotSet");
            throw new RuntimeException(msg);
        }
        String ir = System.getProperty("com.sun.aas.installRoot");
        if (!SMFService.ok(ir)) {
            throw new RuntimeException("Internal Error - System Property not set: com.sun.aas.installRoot");
        }
        File rootDir = SmartFile.sanitize((File)new File(ir));
        if (!rootDir.isDirectory()) {
            throw new RuntimeException("Internal Error - Not a directory: " + rootDir);
        }
        File templatesDir = new File(rootDir, REL_PATH_TEMPLATES);
        String filename = this.getType().toString() + MANIFEST_FILE_TEMPL_SUFFIX;
        File f = new File(templatesDir, filename);
        return f.getPath();
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    @Override
    public void createService(Map<String, String> params) throws RuntimeException {
        SMFService smf = new SMFService(params);
        boolean success = false;
        boolean previousManifestExists = new File(smf.getManifestFilePath()).exists();
        try {
            smf.isConfigValid();
            if (this.trace) {
                this.printOut(smf.toString());
            }
            this.validateManifest(smf.getManifestFilePath());
            previousManifestExists = false;
            ServicesUtils.tokenReplaceTemplateAtDestination(smf.tokensAndValues(), smf.getManifestFileTemplatePath(), smf.getManifestFilePath());
            this.validateService(smf);
            success = this.importService(smf);
        }
        catch (Exception e) {
            if (!success && !previousManifestExists) {
                this.cleanupManifest(smf);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] ka = new String[this.pairs.size()];
        Arrays.sort(this.pairs.keySet().toArray(ka));
        for (String n : ka) {
            sb.append(n).append("=").append(this.pairs.get(n)).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    @Override
    public void setDryRun(boolean aDryRun) {
        this.dryRun = aDryRun;
    }

    @Override
    public String getSuccessMessage() {
        String msg = Strings.get("SMFServiceCreated", this.getName(), this.getType().toString(), this.getLocation(), this.getManifestFilePath(), this.shortName);
        if (this.dryRun) {
            msg = msg + Strings.get("dryrun");
        }
        return msg;
    }

    private void init() {
        this.pairs.put(DATE_CREATED_TN, new Date().toString());
        this.pairs.put(SERVICE_NAME_TN, NULL_VALUE);
        this.pairs.put(SERVICE_TYPE_TN, NULL_VALUE);
        this.pairs.put(CFG_LOCATION_TN, NULL_VALUE);
        this.pairs.put(ENTITY_NAME_TN, NULL_VALUE);
        this.pairs.put(FQSN_TN, NULL_VALUE);
        this.pairs.put(START_INSTANCES_TN, START_INSTANCES_DEFAULT_VAL);
        this.pairs.put(AS_ADMIN_PATH_TN, NULL_VALUE);
        this.pairs.put(AS_ADMIN_USER_TN, AS_ADMIN_USER_DEF_VAL);
        this.pairs.put(TIMEOUT_SECONDS_TN, TIMEOUT_SECONDS_DV);
        this.pairs.put(OS_USER_TN, NULL_VALUE);
        this.pairs.put(PRIVILEGES_TN, BASIC_NETADDR_PRIV_VAL);
        this.pairs.put(CREDENTIALS_TN, " ");
    }

    private Set<String> ps2Pairs(String cds) {
        StringTokenizer p = new StringTokenizer(cds, SP_DELIMITER);
        HashSet<String> tokens = new HashSet<String>();
        while (p.hasMoreTokens()) {
            tokens.add(p.nextToken());
        }
        return tokens;
    }

    private boolean canCreateManifest() {
        File mh = new File(MANIFEST_HOME);
        boolean ok = true;
        if (!mh.exists()) {
            ok = mh.mkdirs();
        }
        if (ok && !mh.canWrite()) {
            ok = false;
        }
        return ok;
    }

    private boolean isUserSmfAuthorized(String user, StringBuilder auths) {
        boolean authorized = false;
        String path2Auths = "auths";
        String at = ",";
        String AUTH1 = "solaris.*";
        String AUTH2 = "solaris.smf.*";
        String AUTH3 = "solaris.smf.modify";
        if (System.getProperty("PATH_2_AUTHS") != null) {
            path2Auths = System.getProperty("PATH_2_AUTHS");
        }
        if (System.getProperty("AUTH_TOKEN") != null) {
            at = System.getProperty("AUTH_TOKEN");
        }
        try {
            String[] cmd = new String[]{path2Auths, user};
            ProcessExecutor pe = new ProcessExecutor(cmd);
            pe.setExecutionRetentionFlag(true);
            pe.execute();
            auths.append(pe.getLastExecutionOutput());
            StringTokenizer st = new StringTokenizer(pe.getLastExecutionOutput(), at);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t != null) {
                    t = t.trim();
                }
                if (!"solaris.*".equals(t) && !"solaris.smf.*".equals(t) && !"solaris.smf.modify".equals(t)) continue;
                authorized = true;
                break;
            }
            return authorized;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean fileContainsToken(String path, String t, Map<String, String> tv) throws RuntimeException {
        BufferedInputStream bis = null;
        try {
            boolean present = false;
            bis = new BufferedInputStream(new FileInputStream(path));
            Properties p = new Properties();
            p.load(bis);
            if (p.containsKey(t)) {
                tv.put(t, (String)p.get(t));
                present = true;
            }
            boolean bl = present;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception ee) {
                    SMFService.IGNORE_EXCEPTION(ee);
                }
            }
        }
    }

    private static void IGNORE_EXCEPTION(Exception e) {
    }

    private boolean serviceNameExists(String sn) {
        boolean exists = false;
        try {
            String[] cmd = new String[]{"/usr/bin/svcs", sn};
            ProcessExecutor pe = new ProcessExecutor(cmd);
            pe.setExecutionRetentionFlag(true);
            pe.execute();
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    private void validateManifest(String manifestPath) throws Exception {
        File manifest = new File(manifestPath);
        if (manifest.exists()) {
            String msg = sm.getString("smfManifestExists", (Object)manifest.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        if (manifest.getParentFile().exists()) {
            String msg = sm.getString("smfManifestFolderExists", (Object)manifest.getParentFile().getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        manifest.getParentFile().mkdirs();
        if (this.trace) {
            this.printOut("Manifest validated: " + manifestPath);
        }
    }

    private void validateService(SMFService smf) throws Exception {
        String[] cmda = new String[]{SVCCFG, "validate", smf.getManifestFilePath()};
        ProcessExecutor pe = new ProcessExecutor(cmda);
        pe.execute();
        if (this.trace) {
            this.printOut("Validated the SMF Service: " + smf.getFQSN() + " using: " + SVCCFG);
        }
    }

    private boolean importService(SMFService smf) throws Exception {
        String[] cmda = new String[]{SVCCFG, "import", smf.getManifestFilePath()};
        ProcessExecutor pe = new ProcessExecutor(cmda);
        if (!this.dryRun) {
            pe.execute();
        }
        if (this.trace) {
            this.printOut("Imported the SMF Service: " + smf.getFQSN());
        }
        return true;
    }

    private void cleanupManifest(SMFService smf) throws RuntimeException {
        File failedServiceNode;
        File manifest = new File(smf.getManifestFilePath());
        if (manifest.exists()) {
            manifest.delete();
            manifest.deleteOnExit();
            if (this.trace) {
                this.printOut("Attempted deleting failed service manifest: " + manifest.getAbsolutePath());
            }
        }
        if ((failedServiceNode = manifest.getParentFile()).exists()) {
            failedServiceNode.delete();
            failedServiceNode.deleteOnExit();
            if (this.trace) {
                this.printOut("Attempted deleting failed service folder: " + failedServiceNode.getAbsolutePath());
            }
        }
    }

    private void printOut(String s) {
        System.out.println(s);
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }
}

