/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.scripting.jruby.Messages;
import org.glassfish.scripting.jruby.RackApplicationChooser;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;
import org.glassfish.scripting.jruby.common.config.JRubyRuntimeConfig;
import org.glassfish.scripting.jruby.config.JrubyContainer;
import org.glassfish.scripting.jruby.config.JrubyRuntimePool;

public class JRubyConfigImpl
implements JRubyConfig {
    private final String jrubyHome;
    private final String railsRoot;
    private final String contextRoot;
    private final String environment;
    private final JRubyConfig.Framework framework;
    private boolean mtSafe = false;
    private final String gemPath;
    private final String appName;
    private JRubyRuntimeConfig runtimeConfig;
    private final Logger logger;
    private final JrubyContainer containerConfig;
    private static final String V3_JRUBY_HOME = System.getProperty("com.sun.aas.installRoot") + File.separator + "modules" + File.separator + "jruby";

    public JRubyConfigImpl(Properties props, String appName, String railsRoot, String contextRoot, Logger logger, JrubyContainer containerConfig) {
        String containerJRubyHome;
        this.logger = logger;
        this.railsRoot = railsRoot;
        this.contextRoot = contextRoot;
        this.appName = appName;
        this.containerConfig = containerConfig;
        String home = System.getProperty("jruby.home");
        if (home != null && home.equals(V3_JRUBY_HOME)) {
            home = null;
        }
        if (props.getProperty("jruby.home") != null) {
            home = props.getProperty("jruby.home");
        } else if (containerConfig != null && containerConfig.getJrubyHome() != null && containerConfig.getJrubyHome().length() > 0 && new File(containerJRubyHome = containerConfig.getJrubyHome()).exists()) {
            home = containerJRubyHome;
        }
        String newJRubyIPSLocation = System.getProperty("com.sun.aas.installRoot") + File.separator + "jruby";
        if (home != null) {
            if (!new File(home).exists()) {
                logger.log(Level.SEVERE, Messages.format("jrubyconfig.jruby.home.not.found", home));
                throw new IllegalArgumentException(Messages.format("jrubyconfig.jruby.home.not.found", home));
            }
        } else if (new File(newJRubyIPSLocation).exists()) {
            home = newJRubyIPSLocation;
        } else {
            logger.log(Level.SEVERE, Messages.format("jrubyconfig.jruby.home.not.found", newJRubyIPSLocation));
            throw new IllegalArgumentException(Messages.format("jrubyconfig.jruby.home.not.found", newJRubyIPSLocation));
        }
        File f = new File(home);
        try {
            home = f.getCanonicalPath();
        }
        catch (IOException e) {
            home = f.getAbsolutePath();
        }
        this.jrubyHome = home;
        String re = System.getProperty("rails.env");
        if (re == null) {
            re = props.getProperty("jruby.rackEnv");
        }
        if (re == null) {
            re = System.getenv("RAILS_ENV");
        }
        this.environment = re == null ? "development" : re;
        logger.info(Messages.format("jrubyconfig.environment", appName, this.environment));
        String applicationType = props.getProperty("jruby.applicationType") == null ? System.getProperty("jruby.applicationType") : props.getProperty("jruby.applicationType");
        this.framework = new RackApplicationChooser().which(this.appRoot(), applicationType);
        String val = System.getProperty("jruby.MTSafe");
        if (val == null) {
            val = props.getProperty("jruby.MTSafe");
        }
        if (val == null && this.framework != null && (this.framework.type().equals("sinatra") || this.framework.type().equals("merb"))) {
            val = "true";
        }
        this.mtSafe = Boolean.valueOf(val);
        this.gemPath = System.getenv("GEM_PATH") == null ? System.getProperty("gem.path") : "";
        int numRt = 1;
        int numMinRt = -1;
        int numMaxRt = -1;
        String jrubyRuntime = System.getProperty("jruby.runtime");
        String jrubyMinRuntime = System.getProperty("jruby.runtime.min");
        String jrubyMaxRuntime = System.getProperty("jruby.runtime.max");
        JrubyRuntimePool poolConfig = containerConfig.getJrubyRuntimePool();
        int configuredRuntime = 0;
        int configuredMinRuntime = 0;
        int configuredMaxRuntime = 0;
        try {
            configuredRuntime = this.toInt(poolConfig.getInitialPoolSize(), "initial-pool-size");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            configuredMinRuntime = this.toInt(poolConfig.getMinPoolSize(), "min-pool-size");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            configuredMaxRuntime = this.toInt(poolConfig.getMaxPoolSize(), "max-pool-size");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            if (props.getProperty("jruby.runtime") != null) {
                numRt = this.toInt(props.getProperty("jruby.runtime"), "jruby.runtime");
            } else if (jrubyRuntime != null) {
                numRt = this.toInt(jrubyRuntime, "jruby.runtime");
            } else if (configuredRuntime > 0) {
                numRt = configuredRuntime;
            }
            if (props.getProperty("jruby.runtime.min") != null) {
                numMinRt = this.toInt(props.getProperty("jruby.runtime.min"), "jruby.runtime.min");
            } else if (jrubyMinRuntime != null) {
                numMinRt = this.toInt(jrubyMinRuntime, "jruby.runtime.min");
            } else if (configuredMinRuntime > 0) {
                numMinRt = configuredMinRuntime;
            }
            if (props.getProperty("jruby.runtime.max") != null) {
                numMaxRt = this.toInt(props.getProperty("jruby.runtime.max"), "jruby.runtime.max");
            } else if (jrubyMaxRuntime != null) {
                numMaxRt = this.toInt(jrubyMaxRuntime, "jruby.runtime.max");
            } else if (configuredMaxRuntime > 0) {
                numMaxRt = configuredMaxRuntime;
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (numRt > numMaxRt) {
            numMaxRt = numRt;
        }
        final int minRuntime = numMinRt;
        final int maxRuntime = numMaxRt;
        final int numberOfRuntime = numRt;
        this.runtimeConfig = new JRubyRuntimeConfig(){

            public int getInitRuntime() {
                return numberOfRuntime;
            }

            public int getMinRuntime() {
                return minRuntime;
            }

            public int getMaxRuntime() {
                return maxRuntime;
            }
        };
    }

    private int toInt(String value, String propName) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            this.logger.log(Level.WARNING, Messages.format("jrubyconfig.runtimes.invalid", value, propName), ex);
            throw ex;
        }
    }

    public String jrubyHome() {
        return this.jrubyHome;
    }

    public String appRoot() {
        return this.railsRoot;
    }

    public String contextRoot() {
        return this.contextRoot;
    }

    public String environment() {
        return this.environment;
    }

    public JRubyConfig.Framework framework() {
        return this.framework;
    }

    public String gemPath() {
        return this.gemPath;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isMTSafe() {
        return this.mtSafe;
    }

    public JRubyRuntimeConfig runtimeConfig() {
        return this.runtimeConfig;
    }

    public String getAppName() {
        return this.appName;
    }
}

