/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.scripting.monitor.utils.TimeStat;

@AMXMetadata(type="jruby-http-mon", group="monitoring")
@ManagedObject
@Description(value="Ruby application HTTP stats")
public class JRubyHttpStatsProvider {
    private final Logger logger = Logger.getLogger(JRubyHttpStatsProvider.class.getName());
    private final CountStatisticImpl averageProcessingTime = new CountStatisticImpl("AverageRequestProcessingTime", "millisecond", "Average request processing time");
    private final CountStatisticImpl reqPerSec = new CountStatisticImpl("Requests/Seconds", "count", "Requests per seconds");
    private final CountStatisticImpl requestCount = new CountStatisticImpl("RequestCounter", "count", "Number of HTTP requests received");
    private final CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Number of responses with a status code greater than 400");
    private final CountStatisticImpl error200Count = new CountStatisticImpl("Count200", "count", "Number of responses with a status code equal to 200");
    private final CountStatisticImpl error2xxCount = new CountStatisticImpl("Count2xx", "count", "Number of responses with a status code in the 2xx range");
    private final CountStatisticImpl error302Count = new CountStatisticImpl("Count302", "count", "Number of responses with a status code equal to 302");
    private final CountStatisticImpl error304Count = new CountStatisticImpl("Count304", "count", "Number of responses with a status code equal to 304");
    private final CountStatisticImpl error3xxCount = new CountStatisticImpl("Count3xx", "count", "Number of responses with a status code in the 3xx range");
    private final CountStatisticImpl error400Count = new CountStatisticImpl("Count400", "count", "Number of responses with a status code equal to 400");
    private final CountStatisticImpl error401Count = new CountStatisticImpl("Count401", "count", "Number of responses with a status code equal to 401");
    private final CountStatisticImpl error403Count = new CountStatisticImpl("Count403", "count", "Number of responses with a status code equal to 403");
    private final CountStatisticImpl error404Count = new CountStatisticImpl("Count404", "count", "Number of responses with a status code equal to 404");
    private final CountStatisticImpl error4xxCount = new CountStatisticImpl("Count4xx", "count", "Number of responses with a status code in the 4xx range");
    private final CountStatisticImpl error503Count = new CountStatisticImpl("Count503", "count", "Number of responses with a status code equal to 503");
    private final CountStatisticImpl error5xxCount = new CountStatisticImpl("Count5xx", "count", "Number of responses with a status code in the 5xx range");
    private final CountStatisticImpl errorOtherCount = new CountStatisticImpl("CountOther", "count", "Number of responses with other status codes");
    private final HashMap<String, CountStatisticImpl> errorMap = new HashMap();
    private TimeStat timer;
    private final String appName;
    private final String contextPath;
    private StringStatisticImpl serverAddress = new StringStatisticImpl("ServerAddress", null, "Server address");

    public JRubyHttpStatsProvider(String appName, String contextPath) {
        this.appName = appName;
        this.contextPath = contextPath;
        this.errorMap.put("200", this.error200Count);
        this.errorMap.put("2", this.error2xxCount);
        this.errorMap.put("302", this.error302Count);
        this.errorMap.put("304", this.error304Count);
        this.errorMap.put("3", this.error3xxCount);
        this.errorMap.put("400", this.error400Count);
        this.errorMap.put("401", this.error401Count);
        this.errorMap.put("403", this.error403Count);
        this.errorMap.put("404", this.error404Count);
        this.errorMap.put("4", this.error4xxCount);
        this.errorMap.put("503", this.error503Count);
        this.errorMap.put("5", this.error5xxCount);
        this.errorMap.put("9", this.errorOtherCount);
        this.timer = new TimeStat();
    }

    @ProbeListener(value="glassfish:jruby:http:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="port") int port) {
        if (this.serverAddress == null) {
            this.serverAddress.setCurrent(serverName + ":" + port);
        }
        this.requestCount.increment();
        this.timer.entry();
    }

    @ProbeListener(value="glassfish:jruby:http:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="statusCode") int statusCode) {
        this.timer.exit();
        this.incrementStatsCounter(statusCode);
    }

    @ManagedAttribute
    @Description(value="Server address")
    public StringStatistic getAddress() {
        return this.serverAddress;
    }

    @ManagedAttribute
    @Description(value="Total requests processed so far")
    public CountStatistic getRequestCount() {
        return this.requestCount;
    }

    @ManagedAttribute
    @Description(value="Requests/Second")
    public CountStatistic getRequestPerSecond() {
        long totalTime = this.timer.getTotalTime(TimeStat.UNIT.SECOND);
        long rps = totalTime == 0L ? 0L : this.requestCount.getCount() / totalTime;
        this.reqPerSec.setCount(rps);
        return this.reqPerSec;
    }

    @ManagedAttribute
    @Description(value="Average request processing time in milliseconds")
    public CountStatistic getAverageProcessingTime() {
        if (this.requestCount.getCount() == 0L) {
            this.averageProcessingTime.setCount(0L);
        } else {
            this.averageProcessingTime.setCount(this.timer.getTotalTime(TimeStat.UNIT.MILLISECOND) / this.requestCount.getCount());
        }
        return this.averageProcessingTime;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="")
    public CountStatistic getErrorCount() {
        return this.errorCount;
    }

    @ManagedAttribute(id="count200")
    @Description(value="")
    public CountStatistic getError200Count() {
        return this.error200Count;
    }

    @ManagedAttribute(id="count2xx")
    @Description(value="")
    public CountStatistic getError2xxCount() {
        return this.error2xxCount;
    }

    @ManagedAttribute(id="count302")
    @Description(value="")
    public CountStatistic getError302Count() {
        return this.error302Count;
    }

    @ManagedAttribute(id="count304")
    @Description(value="")
    public CountStatistic getError304Count() {
        return this.error304Count;
    }

    @ManagedAttribute(id="count3xx")
    @Description(value="")
    public CountStatistic getError3xxCount() {
        return this.error3xxCount;
    }

    @ManagedAttribute(id="count400")
    @Description(value="")
    public CountStatistic getError400Count() {
        return this.error400Count;
    }

    @ManagedAttribute(id="count401")
    @Description(value="")
    public CountStatistic getError401Count() {
        return this.error401Count;
    }

    @ManagedAttribute(id="count403")
    @Description(value="")
    public CountStatistic getError403Count() {
        return this.error403Count;
    }

    @ManagedAttribute(id="count404")
    @Description(value="")
    public CountStatistic getError404Count() {
        return this.error404Count;
    }

    @ManagedAttribute(id="count4xx")
    @Description(value="")
    public CountStatistic getError4xxCount() {
        return this.error4xxCount;
    }

    @ManagedAttribute(id="count503")
    @Description(value="")
    public CountStatistic getError503Count() {
        return this.error503Count;
    }

    @ManagedAttribute(id="count5xx")
    @Description(value="")
    public CountStatistic getError5xxCount() {
        return this.error5xxCount;
    }

    @ManagedAttribute(id="countother")
    @Description(value="")
    public CountStatistic getErrorOtherCount() {
        return this.errorOtherCount;
    }

    private void incrementStatsCounter(int statusCode) {
        CountStatisticImpl errorCounter;
        if (statusCode >= 400) {
            this.errorCount.increment();
        }
        if ((errorCounter = this.errorMap.get(Integer.toString(statusCode))) != null) {
            errorCounter.increment();
            errorCounter = this.errorMap.get(Integer.toString(Math.round(statusCode / 100)));
            if (errorCounter != null) {
                errorCounter.increment();
            }
            return;
        }
        errorCounter = this.errorMap.get(Integer.toString(Math.round(statusCode / 100)));
        if (errorCounter == null) {
            errorCounter = this.errorMap.get("9");
        }
        errorCounter.increment();
    }
}

