/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.Interceptor;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private final BeanManagerImpl deploymentManager;
    private final Set<WeldClass<?>> classes = new HashSet();

    public BeanDeployer(BeanManagerImpl manager, BeanManagerImpl deploymentManager, EjbDescriptors ejbDescriptors) {
        super(manager, new BeanDeployerEnvironment(ejbDescriptors, manager));
        this.deploymentManager = deploymentManager;
    }

    public BeanDeployer addClass(Class<?> clazz) {
        ProcessAnnotatedTypeImpl<?> event;
        ClassTransformer classTransformer = Container.instance().deploymentServices().get(ClassTransformer.class);
        if (!(clazz.isAnnotation() || clazz.isEnum() || (event = ProcessAnnotatedTypeImpl.fire(this.deploymentManager, classTransformer.loadClass(clazz))).isVeto())) {
            if (event.getAnnotatedType() instanceof WeldClass) {
                this.classes.add((WeldClass)event.getAnnotatedType());
            } else {
                this.classes.add(classTransformer.loadClass(event.getAnnotatedType()));
            }
        }
        return this;
    }

    public BeanDeployer addClass(AnnotatedType<?> clazz) {
        ClassTransformer classTransformer = Container.instance().deploymentServices().get(ClassTransformer.class);
        this.classes.add(classTransformer.loadClass(clazz));
        return this;
    }

    public BeanDeployer addClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public BeanDeployer createBeans() {
        for (WeldClass<?> clazz : this.classes) {
            boolean managedBeanOrDecorator;
            boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(clazz.getJavaClass()) && this.isTypeManagedBeanOrDecorator(clazz);
            if (managedBeanOrDecorator && clazz.isAnnotationPresent(Decorator.class)) {
                this.createDecorator(clazz);
                continue;
            }
            if (managedBeanOrDecorator && clazz.isAnnotationPresent(Interceptor.class)) {
                this.createInterceptor(clazz);
                continue;
            }
            if (!managedBeanOrDecorator || clazz.isAbstract()) continue;
            this.createSimpleBean(clazz);
        }
        for (InternalEjbDescriptor ejbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            this.createEnterpriseBean(ejbDescriptor);
        }
        return this;
    }
}

