/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.lang.annotation.Annotation;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.Container;
import org.jboss.weld.ContextualStore;
import org.jboss.weld.context.AbstractContext;
import org.jboss.weld.context.SerializableContextualInstance;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.log.LogProvider;
import org.jboss.weld.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapContext
extends AbstractContext {
    private static LogProvider log = Logging.getLogProvider(AbstractMapContext.class);
    private static ReentrantLock creationLock = new ReentrantLock();

    public AbstractMapContext(Class<? extends Annotation> scopeType) {
        super(scopeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        if (contextual == null) {
            throw new IllegalArgumentException("Must provide a contextual to get");
        }
        String id = AbstractMapContext.getId(contextual);
        ContextualInstance beanInstance = this.getBeanStore().get(id);
        if (beanInstance != null) {
            return beanInstance.getInstance();
        }
        if (creationalContext != null) {
            boolean needCreationLock = this.isCreationLockRequired();
            try {
                T instance;
                if (needCreationLock) {
                    creationLock.lock();
                    beanInstance = this.getBeanStore().get(id);
                    if (beanInstance != null) {
                        Object t = beanInstance.getInstance();
                        return t;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableContextualInstance<Contextual<T>, T>(contextual, instance, creationalContext);
                    this.getBeanStore().put(id, beanInstance);
                }
                T t = instance;
                return t;
            }
            finally {
                if (needCreationLock) {
                    creationLock.unlock();
                }
            }
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private <T> void destroy(String id) {
        log.trace("Destroying " + id);
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        ContextualInstance beanInstance = this.getBeanStore().get(id);
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    public void destroy() {
        log.trace("Destroying context");
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        for (String id : this.getBeanStore().getContextualIds()) {
            this.destroy(id);
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    protected abstract boolean isCreationLockRequired();

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.getBeanStore() != null) {
            this.getBeanStore().clear();
        }
    }

    protected static <T> Contextual<T> getContextual(String id) {
        return Container.instance().deploymentServices().get(ContextualStore.class).getContextual(id);
    }

    protected static String getId(Contextual<?> contextual) {
        return Container.instance().deploymentServices().get(ContextualStore.class).putIfAbsent(contextual);
    }
}

