/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.el;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Namespace {
    private final String qualifiedName;
    private final String name;
    private final Map<String, Namespace> children;

    public Namespace(Iterable<String> namespaces) {
        this(null, null);
        for (String namespace : namespaces) {
            String[] hierarchy = namespace.split("\\.");
            Namespace n = this;
            for (String s : hierarchy) {
                n = n.putIfAbsent(s);
            }
        }
    }

    protected Namespace(String name, String qualifiedName) {
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.children = new HashMap<String, Namespace>();
    }

    private Namespace putIfAbsent(String key) {
        Namespace result = this.children.get(key);
        if (result == null) {
            result = new Namespace(key, this.qualifyName(key));
            this.children.put(key, result);
        }
        return result;
    }

    public Namespace get(String key) {
        return this.children.get(key);
    }

    public boolean contains(String key) {
        return this.children.containsKey(key);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    protected Map<String, Namespace> getChildren() {
        return this.children;
    }

    protected String getName() {
        return this.name;
    }

    public String qualifyName(String suffix) {
        return this.qualifiedName == null ? suffix : this.qualifiedName + "." + suffix;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Namespace) {
            Namespace that = (Namespace)other;
            return this.getQualifiedName().equals(that.getQualifiedName());
        }
        return false;
    }

    public String toString() {
        return "Namespace(" + (this.name == null ? "Root" : this.name) + ')';
    }
}

