/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Lifecycle;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredEventNotification<T>
implements Runnable {
    private static Log log = Logging.getLog(DeferredEventNotification.class);
    protected final ObserverMethodImpl<?, T> observer;
    protected final T event;

    public DeferredEventNotification(T event, ObserverMethodImpl<?, T> observer) {
        this.observer = observer;
        this.event = event;
    }

    @Override
    public void run() {
        try {
            log.debug((Object)("Sending event [" + this.event + "] directly to observer " + this.observer), new Object[0]);
            new RunInRequest(){

                protected void execute() {
                    DeferredEventNotification.this.observer.sendEvent(DeferredEventNotification.this.event);
                }
            }.run();
        }
        catch (Exception e) {
            log.error((Object)("Failure while notifying an observer of event [" + this.event + "]"), e, new Object[0]);
        }
    }

    public String toString() {
        return "Deferred event [" + this.event + "] for [" + this.observer + "]";
    }

    private static abstract class RunInRequest {
        private RunInRequest() {
        }

        protected abstract void execute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Lifecycle lifecycle = Container.instance().deploymentServices().get(ContextLifecycle.class);
            boolean requestActive = lifecycle.isRequestActive();
            ConcurrentHashMapBeanStore requestBeanStore = new ConcurrentHashMapBeanStore();
            try {
                if (!requestActive) {
                    lifecycle.beginRequest("async invocation", requestBeanStore);
                }
                this.execute();
            }
            finally {
                if (!requestActive) {
                    lifecycle.endRequest("async invocation", requestBeanStore);
                }
            }
        }
    }
}

