/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.Server;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class EmbeddedDeployerImpl
implements EmbeddedDeployer {
    @Inject
    Deployment deployment;
    @Inject
    Server server;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Habitat habitat;
    @Inject
    ArchiveFactory factory;
    @Inject
    SnifferManager snifferMgr;
    @Inject
    ServerEnvironment env;
    @Inject
    DasConfig config;
    private static final Logger l = LogDomains.getLogger(EmbeddedDeployerImpl.class, (String)"javax.enterprise.system.tools.deployment");
    Map<String, EmbeddedDeployedInfo> deployedApps = new HashMap<String, EmbeddedDeployedInfo>();
    static final Logger logger = LogDomains.getLogger(EmbeddedDeployerImpl.class, (String)"javax.enterprise.system.core");

    public File getApplicationsDir() {
        return this.env.getApplicationRepositoryPath();
    }

    public File getAutoDeployDir() {
        return new File(this.env.getDomainRoot(), this.config.getAutodeployDir());
    }

    public void setAutoDeploy(final boolean flag) {
        boolean active;
        String value = this.config.getAutodeployEnabled();
        boolean bl = active = value != null && Boolean.parseBoolean(this.config.getAutodeployEnabled());
        if (active != flag) {
            try {
                ConfigSupport.apply(new SingleConfigCode<DasConfig>(){

                    @Override
                    public Object run(DasConfig dasConfig) throws PropertyVetoException, TransactionFailure {
                        dasConfig.setAutodeployEnabled(Boolean.valueOf(flag).toString());
                        return null;
                    }
                }, this.config);
            }
            catch (TransactionFailure e) {
                logger.log(Level.SEVERE, "Exception while enabling or disabling the autodeployment of applications", e);
            }
        }
    }

    public String deploy(File archive, DeployCommandParameters params) {
        try {
            ReadableArchive r = this.factory.openArchive(archive);
            return this.deploy(r, params);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String deploy(ReadableArchive archive, DeployCommandParameters params) {
        Collection sniffers;
        PlainTextActionReporter report = new PlainTextActionReporter();
        DeploymentContextImpl initialContext = new DeploymentContextImpl((ActionReport)report, logger, archive, (OpsParams)params, this.env);
        ArchiveHandler archiveHandler = null;
        try {
            archiveHandler = this.deployment.getArchiveHandler(archive);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (archiveHandler == null) {
            throw new RuntimeException("Cannot find archive handler for source archive");
        }
        if (params.name == null) {
            params.name = archiveHandler.getDefaultApplicationName(archive, (DeploymentContext)initialContext);
        }
        ExtendedDeploymentContext context = null;
        try {
            context = this.deployment.getBuilder(logger, (OpsParams)params, (ActionReport)report).source(archive).archiveHandler(archiveHandler).build((ExtendedDeploymentContext)initialContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (params.property != null) {
            context.getAppProps().putAll((Map<?, ?>)params.property);
        }
        if (params.properties != null) {
            context.getAppProps().putAll((Map<?, ?>)params.properties);
        }
        ClassLoader cl = context.getClassLoader();
        if (archiveHandler instanceof CompositeHandler) {
            context.getAppProps().setProperty("isComposite", "true");
            sniffers = this.snifferMgr.getCompositeSniffers((DeploymentContext)context);
        } else {
            sniffers = this.snifferMgr.getSniffers(archive, cl);
        }
        ArrayList<Sniffer> finalSniffers = new ArrayList<Sniffer>();
        for (EmbeddedContainer container : this.server.getContainers()) {
            for (Sniffer sniffer : container.getSniffers()) {
                if (!sniffers.contains(sniffer)) continue;
                finalSniffers.add(sniffer);
            }
        }
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.deployment.deploy(finalSniffers, context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (appInfo != null) {
            boolean isDirectory = new File(archive.getURI().getPath()).isDirectory();
            EmbeddedDeployedInfo info = new EmbeddedDeployedInfo(appInfo, context.getModulePropsMap(), isDirectory);
            this.deployedApps.put(appInfo.getName(), info);
            return appInfo.getName();
        }
        return null;
    }

    public void undeploy(String name, UndeployCommandParameters params) {
        ApplicationInfo appInfo;
        ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
        EmbeddedDeployedInfo info = this.deployedApps.get(name);
        ApplicationInfo applicationInfo = appInfo = info != null ? info.appInfo : null;
        if (appInfo == null) {
            appInfo = this.deployment.get(name);
        }
        if (appInfo == null) {
            report.setMessage("Cannot find deployed application of name " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive source = appInfo.getSource();
        if (source == null) {
            report.setMessage("Cannot get source archive for undeployment");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (params == null) {
            params = new UndeployCommandParameters(name);
        }
        params.origin = OpsParams.Origin.undeploy;
        ExtendedDeploymentContext deploymentContext = null;
        try {
            deploymentContext = this.deployment.getBuilder(logger, (OpsParams)params, report).source(source).build();
            if (info != null) {
                for (ModuleInfo module : appInfo.getModuleInfos()) {
                    info.map.put(module.getName(), module.getModuleProps());
                    deploymentContext.getModuleProps().putAll((Map<?, ?>)module.getModuleProps());
                }
                deploymentContext.setModulePropsMap(info.map);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.deployment.undeploy(name, deploymentContext);
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            if (params.keepreposdir == null) {
                params.keepreposdir = false;
            }
            if (!params.keepreposdir.booleanValue() && !info.isDirectory && source.exists()) {
                FileUtils.whack((File)new File(source.getURI()));
            }
            deploymentContext.clean();
        }
    }

    public void undeployAll() {
        for (String appName : this.deployedApps.keySet()) {
            this.undeploy(appName, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmbeddedDeployedInfo {
        final ApplicationInfo appInfo;
        final Map<String, Properties> map;
        final boolean isDirectory;

        public EmbeddedDeployedInfo(ApplicationInfo appInfo, Map<String, Properties> map, boolean isDirectory) {
            this.appInfo = appInfo;
            this.map = map;
            this.isDirectory = isDirectory;
        }
    }
}

