/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

public class WindowNode
extends SingleChildResultSetNode {
    private String windowName;
    private ResultColumnList partitionDefinition;
    private OrderByList orderByList;
    private Object frameDefinition;
    private int windowFunctionLevel;
    private Properties tableProperties;
    private int numTables;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        this.windowName = (String)object;
        this.partitionDefinition = (ResultColumnList)object2;
        this.orderByList = (OrderByList)object3;
        this.frameDefinition = object4;
        this.windowFunctionLevel = -1;
    }

    public ResultSetNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.numTables = n;
        this.referencedTableMap = new JBitSet(n);
        int n2 = fromList.size();
        for (int i = 0; i < n2; ++i) {
            this.referencedTableMap.or(((FromTable)fromList.elementAt(i)).getReferencedTableMap());
        }
        return this;
    }

    public WindowNode bind(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        return this;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.resultColumns.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n);
        int n2 = -1;
        int n3 = 0;
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n4 = 0;
        for (int i = n - 1; i >= 0; --i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (resultColumn.isWindowFunction() && n4 < this.windowFunctionLevel) {
                ++n4;
                continue;
            }
            formatableBitSet.set(i);
            ++n3;
        }
        n2 = activationClassBuilder.addItem(formatableBitSet);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        this.resultColumns.generateHolder(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.windowFunctionLevel);
        methodBuilder.push(n2);
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getWindowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
        if (this.cursorTargetTable) {
            activationClassBuilder.rememberCursorTarget(methodBuilder);
        }
    }

    public ResultSetNode considerMaterialization(JBitSet jBitSet) throws StandardException {
        return this;
    }

    public boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return false;
    }

    public int getWindowFunctionLevel() {
        return this.windowFunctionLevel;
    }

    public void setWindowFunctionLevel(int n) {
        this.windowFunctionLevel = n;
    }
}

