/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Calendar;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.handlers.MonitoringHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.admingui.util.SunOptionUtil;

public class WoodstockHandler {
    private Option[] jumpMenuOptions = null;

    public static void uploadFileToTempDir(HandlerContext handlerCtx) {
        UploadedFile uploadedFile = (UploadedFile)handlerCtx.getInputValue("file");
        File tmpFile = null;
        String uploadTmpFile = "";
        if (uploadedFile != null) {
            int index;
            String name = uploadedFile.getOriginalName();
            int lastIndex = name.lastIndexOf("\\");
            if (lastIndex != -1) {
                name = name.substring(lastIndex + 1, name.length());
            }
            if ((index = name.indexOf(".")) <= 0) {
                String mesg = GuiUtil.getMessage((String)"msg.deploy.nullArchiveError");
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)mesg);
                return;
            }
            String suffix = name.substring(index);
            String prefix = name.substring(0, index);
            handlerCtx.setOutputValue("origPath", (Object)prefix);
            try {
                if (prefix.length() <= 2) {
                    prefix = prefix + new Random().nextInt(100000);
                }
                tmpFile = File.createTempFile(prefix, suffix);
                tmpFile.deleteOnExit();
                uploadedFile.write(tmpFile);
                uploadTmpFile = tmpFile.getCanonicalPath();
            }
            catch (IOException ioex) {
                try {
                    uploadTmpFile = tmpFile.getAbsolutePath();
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("uploadedTempFile", (Object)uploadTmpFile);
    }

    public static void setDisableConnectionPoolTableField(HandlerContext handlerCtx) {
        String methodValue = (String)handlerCtx.getInputValue("methodValue");
        DropDown tableDD = (DropDown)handlerCtx.getInputValue("tableDD");
        Field validationField = (Field)handlerCtx.getInputValue("validationField");
        if ("table".equals(methodValue)) {
            tableDD.setDisabled(false);
            validationField.setDisabled(true);
        } else if ("custom-validation".equals(methodValue)) {
            tableDD.setDisabled(true);
            validationField.setDisabled(false);
        } else {
            tableDD.setDisabled(true);
            validationField.setDisabled(true);
        }
    }

    public static void createHyperlinkArray(HandlerContext handlerCtx) {
        FacesContext ctx = handlerCtx.getFacesContext();
        ExternalContext extCtx = ctx.getExternalContext();
        Map reqParams = extCtx.getRequestParameterValuesMap();
        String[] linkText = (String[])reqParams.get("text");
        String[] linkUrl = (String[])reqParams.get("urls");
        if (linkText == null) {
            return;
        }
        int len = linkText.length;
        Hyperlink[] arr = new Hyperlink[len];
        String url = null;
        String ctxPath = extCtx.getRequestContextPath();
        int ctxPathSize = ctxPath.length();
        for (int idx = 0; idx < len; ++idx) {
            arr[idx] = new Hyperlink();
            arr[idx].setId("bcLnk" + idx);
            arr[idx].setRendererType("com.sun.webui.jsf.Hyperlink");
            arr[idx].setText((Object)linkText[idx]);
            url = linkUrl[idx];
            if (url.startsWith(ctxPath)) {
                url = url.substring(ctxPathSize);
            }
            arr[idx].setUrl(url);
        }
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void dummyHyperlinkArray(HandlerContext handlerCtx) {
        Hyperlink[] arr = new Hyperlink[]{new Hyperlink()};
        arr[0].setText((Object)">");
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void StringArrayToSelectItemArray(HandlerContext handlerCtx) {
        String[] stringArray = (String[])handlerCtx.getInputValue("stringArray");
        handlerCtx.setOutputValue("item", (Object)SunOptionUtil.getOptions(stringArray));
    }

    public static void StringToSelectItemArray(HandlerContext handlerCtx) {
        String string = (String)handlerCtx.getInputValue("string");
        if (string.startsWith("[")) {
            string = string.substring(1);
        }
        if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split(",");
        handlerCtx.setOutputValue("item", (Object)SunOptionUtil.getOptions(stringArray));
    }

    public static void selectItemArrayToStrArray(HandlerContext handlerCtx) {
        SelectItem[] item = (SelectItem[])handlerCtx.getInputValue("item");
        if (item == null || item.length == 0) {
            handlerCtx.setOutputValue("strAry", (Object)new String[0]);
            return;
        }
        String[] strAry = new String[item.length];
        for (int i = 0; i < item.length; ++i) {
            strAry[i] = (String)item[i].getValue();
        }
        handlerCtx.setOutputValue("strAry", (Object)strAry);
    }

    public static void getDatePattern(HandlerContext handlerCtx) {
        Calendar calendar = (Calendar)handlerCtx.getInputValue("calendarComponent");
        String pattern = calendar.getDateFormatPattern();
        if (!(pattern != null && pattern.length() != 0 || (pattern = calendar.getDatePicker().getDateFormatPattern()) != null && pattern.length() != 0)) {
            pattern = "MM/dd/yyyy";
        }
        handlerCtx.setOutputValue("pattern", (Object)pattern);
    }

    public void populateServerMonitorDropDown(HandlerContext handlerCtx) {
        OptionGroup tsMenuOptions;
        OptionGroup gcMenuOptions;
        OptionGroup nlMenuOptions;
        List vsList = (List)handlerCtx.getInputValue("VSList");
        List threadList = (List)handlerCtx.getInputValue("ThreadSystemList");
        List gcList = (List)handlerCtx.getInputValue("GCList");
        List nlList = (List)handlerCtx.getInputValue("NLList");
        ArrayList<Object> menuList = new ArrayList<Object>();
        menuList.add(new Option((Object)"", ""));
        OptionGroup vsMenuOptions = WoodstockHandler.getMenuOptions(vsList, "virtual-server", "", false);
        if (vsMenuOptions != null) {
            menuList.add(vsMenuOptions);
        }
        if ((nlMenuOptions = WoodstockHandler.getMenuOptions(nlList, "http-listener", "", false)) != null) {
            menuList.add(nlMenuOptions);
        }
        if ((gcMenuOptions = WoodstockHandler.getMenuOptions(gcList, "garbage-collector", "", false)) != null) {
            menuList.add(gcMenuOptions);
        }
        if ((tsMenuOptions = WoodstockHandler.getMenuOptions(threadList, "thread-system", "", false)) != null) {
            menuList.add(tsMenuOptions);
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
    }

    public void populateResourceMonitorDropDown(HandlerContext handlerCtx) {
        List rList = (List)handlerCtx.getInputValue("ResourceList");
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        ArrayList<Option> resList = new ArrayList<Option>();
        Option[] groupedOptions1 = new Option[]{};
        String firstItem = null;
        if (rList != null) {
            ListIterator rl = rList.listIterator();
            while (rl.hasNext()) {
                String name = (String)rl.next();
                resList.add(new Option((Object)name, name));
                if (firstItem != null) continue;
                firstItem = name;
            }
        }
        groupedOptions1 = resList.toArray(new Option[resList.size()]);
        OptionGroup jumpGroup1 = new OptionGroup();
        jumpGroup1.setLabel("resources");
        jumpGroup1.setOptions(groupedOptions1);
        menuList.add(jumpGroup1);
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
        handlerCtx.setOutputValue("FirstItem", (Object)firstItem);
    }

    public void populateApplicationsMonitorDropDown(HandlerContext handlerCtx) {
        List aList = (List)handlerCtx.getInputValue("AppsList");
        ArrayList<Object> menuList = new ArrayList<Object>();
        ArrayList appsList = new ArrayList();
        Option[] groupedOptions1 = new Option[]{};
        String firstItem = null;
        Object title = null;
        if (aList != null) {
            ListIterator al = aList.listIterator();
            while (al.hasNext()) {
                ArrayList<String> moduleList = new ArrayList<String>();
                String appName = (String)al.next();
                Map modules = V3AMX.getInstance().getApplication(appName).childrenMap("module");
                for (AMXProxy oneModule : modules.values()) {
                    String moduleName = oneModule.getName();
                    boolean hasSfullStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"stateful-session-bean-mon");
                    boolean hasSlessStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"stateless-session-bean-mon");
                    boolean hasWebStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"servlet-instance-mon");
                    boolean hasMdbStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"message-driven-bean-mon");
                    boolean hasPoolStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"bean-pool-mon");
                    boolean hasCacheStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"bean-cache-mon");
                    boolean hasMethodStats = MonitoringHandlers.doesAppProxyExist((String)moduleName, (String)"bean-method-mon");
                    if (!hasSfullStats && !hasSlessStats && !hasWebStats && !hasMdbStats && !hasPoolStats && !hasCacheStats && !hasMethodStats) continue;
                    moduleList.add(moduleName);
                }
                if (moduleList.isEmpty()) {
                    menuList.add(new Option((Object)appName, appName));
                    if (firstItem != null) continue;
                    firstItem = appName;
                    continue;
                }
                OptionGroup menuOptions = WoodstockHandler.getMenuOptions(moduleList, appName, "", false);
                menuList.add(menuOptions);
                if (firstItem != null) continue;
                firstItem = (String)moduleList.get(0);
            }
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
        handlerCtx.setOutputValue("FirstItem", firstItem);
    }

    public void populateComponentDropDown(HandlerContext handlerCtx) {
        List vsList = (List)handlerCtx.getInputValue("VSList");
        String appname = (String)handlerCtx.getInputValue("AppName");
        ArrayList<Object> menuList = new ArrayList<Object>();
        menuList.add(new Option((Object)"", ""));
        if (appname != null && !appname.isEmpty()) {
            List ebs;
            List sbs;
            List mdbs;
            List slessSession;
            List sfullSession;
            if (MonitoringHandlers.doesAppProxyExist((String)appname, (String)"servlet-instance-mon").booleanValue() && vsList != null) {
                ListIterator vl = vsList.listIterator();
                while (vl.hasNext()) {
                    String name = (String)vl.next();
                    List servlets = MonitoringHandlers.servletInstanceValues((String)appname, (String)"servlet-instance-mon", (String)name);
                    if (servlets.isEmpty()) continue;
                    OptionGroup menuOptions = WoodstockHandler.getMenuOptions(servlets, name, "", true);
                    menuList.add(menuOptions);
                }
            }
            if (MonitoringHandlers.doesAppProxyExist((String)appname, (String)"stateful-session-bean-mon").booleanValue() && !(sfullSession = WoodstockHandler.getEJBComponentsMenuOptions(appname, "stateful-session-bean-mon")).isEmpty()) {
                menuList.addAll(sfullSession);
            }
            if (MonitoringHandlers.doesAppProxyExist((String)appname, (String)"stateless-session-bean-mon").booleanValue() && !(slessSession = WoodstockHandler.getEJBComponentsMenuOptions(appname, "stateless-session-bean-mon")).isEmpty()) {
                menuList.addAll(slessSession);
            }
            if (MonitoringHandlers.doesAppProxyExist((String)appname, (String)"message-driven-bean-mon").booleanValue() && !(mdbs = WoodstockHandler.getEJBComponentsMenuOptions(appname, "message-driven-bean-mon")).isEmpty()) {
                menuList.addAll(mdbs);
            }
            if (MonitoringHandlers.doesAppProxyExist((String)appname, (String)"singleton-bean-mon").booleanValue() && !(sbs = WoodstockHandler.getEJBComponentsMenuOptions(appname, "singleton-bean-mon")).isEmpty()) {
                menuList.addAll(sbs);
            }
            if (MonitoringHandlers.doesAppProxyExist((String)appname, (String)"entity-bean-mon").booleanValue() && !(ebs = WoodstockHandler.getEJBComponentsMenuOptions(appname, "entity-bean-mon")).isEmpty()) {
                menuList.addAll(ebs);
            }
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("ComponentList", (Object)this.jumpMenuOptions);
    }

    private static List getEJBComponentsMenuOptions(String appname, String ejbtype) {
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        List ebs = MonitoringHandlers.getAllEjbComps((String)appname, (String)ejbtype, (String)"");
        if (!ebs.isEmpty()) {
            ListIterator li = ebs.listIterator();
            while (li.hasNext() && li.hasNext()) {
                List comps = (List)li.next();
                OptionGroup menuOptions = WoodstockHandler.getMenuOptions(comps, (String)comps.get(0), "", true);
                menuList.add(menuOptions);
                List ebsMethods = MonitoringHandlers.getEjbComps((String)appname, (String)"bean-method-mon", (String)((String)comps.get(0)));
                if (ebsMethods.isEmpty()) continue;
                OptionGroup bmmenuOptions = WoodstockHandler.getMenuOptions(ebsMethods, "bean-methods", (String)comps.get(0), true);
                menuList.add(bmmenuOptions);
            }
        }
        return menuList;
    }

    private static OptionGroup getMenuOptions(List values, String label, String label2, boolean addLabel) {
        ArrayList<Option> nList = new ArrayList<Option>();
        Option[] groupedOptions3 = new Option[]{};
        Collections.sort(values);
        ListIterator nl = values.listIterator();
        if (values == null) {
            return null;
        }
        while (nl.hasNext()) {
            String name = (String)nl.next();
            if (addLabel && label2.equals("")) {
                if (!label.equals(name)) {
                    nList.add(new Option((Object)(label + "/" + name), name));
                    continue;
                }
                nList.add(new Option((Object)name, name));
                continue;
            }
            if (addLabel && !label2.equals("")) {
                nList.add(new Option((Object)(label2 + "/" + label + "/" + name), name));
                continue;
            }
            nList.add(new Option((Object)name, name));
        }
        groupedOptions3 = nList.toArray(new Option[nList.size()]);
        OptionGroup jumpGroup3 = new OptionGroup();
        jumpGroup3.setLabel(label);
        jumpGroup3.setOptions(groupedOptions3);
        return jumpGroup3;
    }
}

