/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Component;
import java.net.URL;
import java.util.Locale;
import javax.help.Map;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class BasicTOCCellRenderer
extends DefaultTreeCellRenderer {
    protected Map map;
    protected TOCView view;

    public BasicTOCCellRenderer(Map map) {
        this(map, null);
    }

    public BasicTOCCellRenderer(Map map, TOCView view) {
        this.map = map;
        this.view = view;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Locale locale;
        Map.ID id;
        String stringValue = "";
        try {
            this.hasFocus = hasFocus;
        }
        catch (IllegalAccessError e) {
            // empty catch block
        }
        TOCItem item = (TOCItem)((DefaultMutableTreeNode)value).getUserObject();
        if (item != null) {
            stringValue = item.getName();
        }
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        ImageIcon icon = null;
        if (item != null && (id = item.getImageID()) != null) {
            try {
                URL url = this.map.getURLFromID(id);
                icon = new ImageIcon(url);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (item != null && (locale = item.getLocale()) != null) {
            this.setLocale(locale);
        }
        if (icon != null) {
            this.setIcon(icon);
        } else if (leaf) {
            this.setIcon(this.getLeafIcon());
        } else if (expanded) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.selected = sel;
        return this;
    }

    public Icon getLeafIcon() {
        Map.ID id;
        ImageIcon icon = null;
        if (this.view != null && (id = this.view.getTopicImageID()) != null) {
            try {
                URL url = this.map.getURLFromID(id);
                icon = new ImageIcon(url);
                return icon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getLeafIcon();
    }

    public Icon getOpenIcon() {
        Map.ID id;
        ImageIcon icon = null;
        if (this.view != null && (id = this.view.getCategoryOpenImageID()) != null) {
            try {
                URL url = this.map.getURLFromID(id);
                icon = new ImageIcon(url);
                return icon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getOpenIcon();
    }

    public Icon getClosedIcon() {
        Map.ID id;
        ImageIcon icon = null;
        if (this.view != null && (id = this.view.getCategoryClosedImageID()) != null) {
            try {
                URL url = this.map.getURLFromID(id);
                icon = new ImageIcon(url);
                return icon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getClosedIcon();
    }
}

