/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.logging.LogDomains;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.DTraceContract;
import org.glassfish.api.monitoring.ProbeProviderInfo;
import org.glassfish.external.probe.provider.annotations.ProbeProvider;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.impl.client.FlashlightProbeClientMediator;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.impl.core.ProbeFactory;
import org.glassfish.flashlight.impl.core.ProbeProviderRegistry;
import org.glassfish.flashlight.impl.core.ProviderImplGenerator;
import org.glassfish.flashlight.impl.core.ProviderSubClassImplGenerator;
import org.glassfish.flashlight.impl.provider.DTraceMethodFinder;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.xml.Probe;
import org.glassfish.flashlight.xml.ProbeParam;
import org.glassfish.flashlight.xml.ProbeProviderStaxParser;
import org.glassfish.flashlight.xml.Provider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeProviderFactory
implements ProbeProviderFactory,
PostConstruct {
    @Inject
    MonitoringService monitoringServiceConfig;
    @Inject
    ProbeProviderEventManager ppem;
    @Inject
    Habitat habitat;
    private static final Set<FlashlightProbeProvider> allProbeProviders = new HashSet<FlashlightProbeProvider>();
    private static final Logger logger = LogDomains.getLogger(FlashlightProbeProviderFactory.class, (String)"javax.enterprise.system.tools.monitor");
    private static final ResourceBundle rb = logger.getResourceBundle();
    private final HashMap<String, Class> primTypes = new HashMap<String, Class>(){
        {
            this.put("int", Integer.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("char", Character.TYPE);
            this.put("short", Short.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("void", Void.TYPE);
        }
    };

    @Override
    public void postConstruct() {
        FlashlightUtils.initialize(this.habitat, this.monitoringServiceConfig);
    }

    @Override
    public void dtraceEnabledChanged(boolean newValue) {
        FlashlightUtils.setDTraceEnabled(newValue);
        if (!newValue) {
            return;
        }
        if (!FlashlightUtils.isDtraceAvailable()) {
            return;
        }
        Collection<FlashlightProbeProvider> pps = ProbeProviderRegistry.getInstance().getAllProbeProviders();
        for (FlashlightProbeProvider pp : pps) {
            if (pp.isDTraceInstrumented()) continue;
            this.handleDTrace(pp);
        }
    }

    @Override
    public void monitoringEnabledChanged(boolean newValue) {
        FlashlightUtils.setMonitoringEnabled(newValue);
        if (newValue && FlashlightUtils.isDtraceEnabled()) {
            this.dtraceEnabledChanged(true);
        }
    }

    @Override
    public <T> T getProbeProvider(Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        return this.getProbeProvider(providerClazz, null);
    }

    @Override
    public <T> T getProbeProvider(Class<T> providerClazz, String invokerId) throws InstantiationException, IllegalAccessException {
        ProbeProvider provAnn = providerClazz.getAnnotation(ProbeProvider.class);
        String moduleProviderName = provAnn.moduleProviderName();
        String moduleName = provAnn.moduleName();
        String probeProviderName = provAnn.probeProviderName();
        if (this.isValidString(moduleProviderName) && this.isValidString(moduleName) && this.isValidString(probeProviderName)) {
            return this.getProbeProvider(moduleProviderName, moduleName, probeProviderName, invokerId, providerClazz);
        }
        logger.log(Level.WARNING, "invalidProbeProvider", new Object[]{providerClazz.getName()});
        return null;
    }

    @Override
    public <T> T getProbeProvider(String moduleName, String providerName, String appName, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return this.getProbeProvider(moduleName, providerName, appName, null, clazz);
    }

    public <T> T getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        FlashlightProbeProvider alreadyExists;
        String origProbeProviderName = probeProviderName;
        Class<T> oldProviderClazz = providerClazz;
        if (invokerId != null) {
            probeProviderName = probeProviderName + invokerId;
            try {
                providerClazz = this.getGeneratedProbeProviderClass(oldProviderClazz, invokerId);
            }
            catch (Exception ex) {
                providerClazz = oldProviderClazz;
            }
        }
        ProbeProviderRegistry ppRegistry = ProbeProviderRegistry.getInstance();
        FlashlightProbeProvider provider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ModuleProviderName= " + moduleProviderName + " \tModule= " + moduleName + "\tProbeProviderName= " + probeProviderName + "\tProviderClazz= " + providerClazz.toString());
        }
        if ((alreadyExists = ppRegistry.getProbeProvider(provider)) != null) {
            Object inst = alreadyExists.getProviderClass().newInstance();
            return inst;
        }
        List<Method> methods = FlashlightUtils.getProbeMethods(providerClazz);
        for (Method m : methods) {
            int sz = m.getParameterTypes().length;
            org.glassfish.external.probe.provider.annotations.Probe pnameAnn = m.getAnnotation(org.glassfish.external.probe.provider.annotations.Probe.class);
            String probeName = pnameAnn != null ? pnameAnn.name() : m.getName();
            boolean self = pnameAnn != null ? pnameAnn.self() : false;
            boolean hidden = pnameAnn != null ? pnameAnn.hidden() : false;
            String[] probeParamNames = FlashlightUtils.getParamNames(m);
            FlashlightProbe probe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParamNames, m.getParameterTypes(), self, hidden);
            probe.setProviderJavaMethodName(m.getName());
            provider.addProbe(probe);
        }
        this.handleDTrace(provider);
        Class<Object> tClazz = providerClazz;
        int mod = providerClazz.getModifiers();
        if (Modifier.isAbstract(mod)) {
            String generatedClassName = provider.getModuleProviderName() + "_Flashlight_" + provider.getModuleName() + "_" + "Probe_" + (provider.getProbeProviderName() == null ? providerClazz.getName() : provider.getProbeProviderName());
            generatedClassName = providerClazz.getName() + "_" + generatedClassName;
            try {
                tClazz = providerClazz.getClassLoader().loadClass(generatedClassName);
                return (T)tClazz.newInstance();
            }
            catch (ClassNotFoundException cnfEx) {
                ProviderImplGenerator gen = new ProviderImplGenerator();
                generatedClassName = gen.defineClass(provider, providerClazz);
                try {
                    tClazz = providerClazz.getClassLoader().loadClass(generatedClassName);
                }
                catch (ClassNotFoundException cnfEx2) {
                    throw new RuntimeException(cnfEx2);
                }
            }
        }
        ppRegistry.getInstance().registerProbeProvider(provider, tClazz);
        T inst = tClazz.newInstance();
        return inst;
    }

    private <T> Class<T> getGeneratedProbeProviderClass(Class<T> oldProviderClazz, String invokerId) {
        String generatedClassName = oldProviderClazz.getName() + invokerId;
        Class<Object> genClazz = null;
        try {
            genClazz = oldProviderClazz.getClassLoader().loadClass(generatedClassName);
            return genClazz;
        }
        catch (Exception cnfEx) {
            try {
                ProviderSubClassImplGenerator gen = new ProviderSubClassImplGenerator(oldProviderClazz, invokerId);
                genClazz = gen.generateAndDefineClass(oldProviderClazz, generatedClassName, invokerId);
                System.out.println("** Loaded generated provider: " + genClazz.getName());
                return genClazz;
            }
            catch (Throwable cnfEx2) {
                throw new RuntimeException(cnfEx2);
            }
        }
    }

    @Override
    public void processXMLProbeProviders(ClassLoader cl, String xml, boolean inBundle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("processProbeProviderXML for " + xml);
        }
        try {
            InputStream is = cl.getResourceAsStream(xml);
            is = inBundle ? cl.getResourceAsStream(xml) : new FileInputStream(xml);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("InputStream = " + is);
            }
            ProbeProviderStaxParser providerXMLParser = new ProbeProviderStaxParser(is);
            List<Provider> providers = providerXMLParser.getProviders();
            for (Provider provider : providers) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(provider.toString());
                }
                this.registerProvider(cl, provider);
            }
        }
        catch (Exception e) {
            String msg = rb.getString("cannotProcessXMLProbeProvider");
            msg = MessageFormat.format(msg, xml);
            logger.log(Level.SEVERE, msg, e);
        }
    }

    public String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    private void handleDTrace(FlashlightProbeProvider provider) {
        DTraceContract dt = FlashlightUtils.getDtraceEngine();
        if (dt == null) {
            return;
        }
        Object dtraceProviderImpl = dt.getProvider((ProbeProviderInfo)provider);
        if (dtraceProviderImpl == null) {
            provider.setDTraceInstrumented(false);
            return;
        }
        provider.setDTraceInstrumented(true);
        Collection<FlashlightProbe> probes = provider.getProbes();
        boolean onlyHidden = true;
        for (FlashlightProbe probe : probes) {
            if (probe.isHidden()) continue;
            DTraceMethodFinder mf = new DTraceMethodFinder(probe, dtraceProviderImpl);
            probe.setDTraceMethod(mf.matchMethod());
            probe.setDTraceProviderImpl(dtraceProviderImpl);
            onlyHidden = false;
        }
        if (!onlyHidden) {
            FlashlightProbeClientMediator.getInstance().registerDTraceListener(provider);
        }
    }

    private void registerProvider(ClassLoader cl, Provider provider) {
        String moduleProviderName = provider.getModuleProviderName();
        String moduleName = provider.getModuleName();
        String probeProviderName = provider.getProbeProviderName();
        String providerClass = provider.getProbeProviderClass();
        List<Probe> probes = provider.getProbes();
        Class<?> providerClazz = null;
        try {
            providerClazz = cl.loadClass(providerClass);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("providerClazz = " + providerClazz);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Could not load the class ( " + providerClazz + " ) for the provider " + providerClass);
            }
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("moduleProviderName = " + moduleProviderName);
            logger.fine("moduleName = " + moduleName);
            logger.fine("probeProviderName = " + probeProviderName);
            logger.fine("probeProviderClass = " + providerClass);
        }
        FlashlightProbeProvider flProvider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        for (Probe probe : probes) {
            String probeName = probe.getProbeName();
            String probeMethod = probe.getProbeMethod();
            boolean hasSelf = probe.hasSelf();
            boolean isHidden = probe.isHidden();
            boolean errorParsingProbe = false;
            String[] probeParams = new String[probe.getProbeParams().size()];
            Class[] paramTypes = new Class[probe.getProbeParams().size()];
            int i = 0;
            for (ProbeParam param : probe.getProbeParams()) {
                probeParams[i] = param.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("          probeParam[" + i + "] = " + probeParams[i]);
                }
                paramTypes[i] = this.getParamType(cl, param.getType());
                if (paramTypes[i] == null) {
                    errorParsingProbe = true;
                    logger.log(Level.SEVERE, "cannotResolveProbeParamTypesForProbe", new Object[]{probeName});
                    break;
                }
                ++i;
            }
            if (errorParsingProbe) {
                errorParsingProbe = false;
                continue;
            }
            FlashlightProbe flProbe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParams, paramTypes, hasSelf, isHidden);
            flProbe.setProviderJavaMethodName(probeMethod);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Constructed probe = " + flProbe.toString());
            }
            flProvider.addProbe(flProbe);
        }
        if (flProvider.getProbes().size() == 0) {
            return;
        }
        this.handleDTrace(flProvider);
        allProbeProviders.add(flProvider);
        ProbeProviderRegistry.getInstance().registerProbeProvider(flProvider, providerClazz);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Provider registered successfully - " + probeProviderName);
        }
    }

    private Class<?> getParamType(ClassLoader cl, String paramTypeStr) {
        Class<?> paramType = null;
        try {
            Class primType = this.primTypes.get(paramTypeStr);
            if (primType != null) {
                return primType;
            }
            paramType = cl.loadClass(paramTypeStr);
        }
        catch (ClassNotFoundException ex) {
            try {
                paramType = cl.loadClass("java.lang." + paramTypeStr);
            }
            catch (Exception e) {
                String errStr = rb.getString("cannotResolveProbeParamTypes");
                errStr = MessageFormat.format(errStr, paramTypeStr);
                logger.log(Level.SEVERE, errStr, e);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("          paramType = " + paramType);
        }
        return paramType;
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }
}

