/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.admin.amx.base.RuntimeRoot;
import org.glassfish.admin.amx.intf.config.Application;
import org.glassfish.admin.amx.intf.config.VirtualServer;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.deployment.client.DFDeploymentProperties;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentHandler {
    public static final String KEEP_SESSIONS = "keepSessions";

    public static void deploy(HandlerContext handlerCtx) {
        String appType = (String)handlerCtx.getInputValue("appType");
        String origPath = (String)handlerCtx.getInputValue("origPath");
        String filePath = (String)handlerCtx.getInputValue("filePath");
        Map allMaps = (Map)handlerCtx.getInputValue("allMaps");
        HashMap<String, String> attrMap = new HashMap<String, String>((Map)allMaps.get(appType));
        if (GuiUtil.isEmpty(origPath)) {
            String mesg = GuiUtil.getMessage("msg.deploy.nullArchiveError");
            GuiUtil.handleError(handlerCtx, mesg);
            return;
        }
        try {
            String decodedName = URLDecoder.decode((String)attrMap.get("name"), "UTF-8");
            attrMap.put("name", decodedName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        DFDeploymentProperties deploymentProps = new DFDeploymentProperties();
        String[] vs = (String[])attrMap.get("virtualservers");
        if (vs != null && vs.length > 0 && !GuiUtil.isEmpty(vs[0])) {
            String vsTargets = GuiUtil.arrayToString(vs, ",");
            deploymentProps.setProperty("virtualservers", vsTargets);
        }
        attrMap.remove("virtualservers");
        List convertToFalseList = (List)attrMap.get("convertToFalseList");
        if (convertToFalseList != null) {
            for (String one : convertToFalseList) {
                if (attrMap.get(one) != null) continue;
                attrMap.put(one, "false");
            }
            attrMap.remove("convertToFalseList");
        }
        Properties props = new Properties();
        for (Object attr : attrMap.keySet()) {
            String key = (String)attr;
            String prefix = "PROPERTY-";
            String value = (String)attrMap.get(key);
            if (value == null) continue;
            if (key.startsWith(prefix)) {
                if (value.equals("")) continue;
                props.setProperty(key.substring(prefix.length()), value);
                continue;
            }
            deploymentProps.setProperty(key, value);
        }
        List propertyList = (List)handlerCtx.getInputValue("propertyList");
        if (propertyList != null) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Map oneRow : propertyList) {
                String name = (String)oneRow.get("Name");
                if (GuiUtil.isEmpty(name)) continue;
                if (propertyNames.contains(name)) {
                    GuiUtil.getLogger().warning("Ignored Duplicate Property Name : " + name);
                    continue;
                }
                propertyNames.add(name);
                String value = (String)oneRow.get("Value");
                if (GuiUtil.isEmpty(value)) continue;
                props.setProperty(name, value);
            }
        }
        if (props.size() > 0) {
            deploymentProps.setProperties(props);
        }
        try {
            DeployUtil.deploy(null, (Properties)deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void redeploy(HandlerContext handlerCtx) {
        try {
            String filePath = (String)handlerCtx.getInputValue("filePath");
            String origPath = (String)handlerCtx.getInputValue("origPath");
            Map deployMap = (Map)handlerCtx.getInputValue("deployMap");
            List convertToFalsList = (List)handlerCtx.getInputValue("convertToFalse");
            if (convertToFalsList != null) {
                for (String one : convertToFalsList) {
                    if (deployMap.get(one) != null) continue;
                    deployMap.put(one, "false");
                }
            }
            String appName = (String)deployMap.get("appName");
            DFDeploymentProperties deploymentProps = new DFDeploymentProperties();
            Application app = V3AMX.getInstance().getApplication(appName);
            String ctxRoot = (String)app.attributesMap().get("ContextRoot");
            if (ctxRoot != null) {
                deploymentProps.setContextRoot(ctxRoot);
            }
            deploymentProps.setForce(true);
            deploymentProps.setUpload(false);
            deploymentProps.setName(appName);
            deploymentProps.setVerify(Boolean.parseBoolean((String)deployMap.get("verify")));
            deploymentProps.setPrecompileJSP(Boolean.parseBoolean((String)deployMap.get("precompilejsp")));
            Properties prop = new Properties();
            prop.setProperty(KEEP_SESSIONS, "" + (String)deployMap.get(KEEP_SESSIONS));
            deploymentProps.setProperties(prop);
            DeployUtil.invokeDeploymentFacility(null, (Properties)deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void undeploy(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("selectedRows");
        Properties dProps = new Properties();
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> undeployedAppList = new ArrayList<String>();
        List selectedRows = (List)obj;
        DFProgressObject progressObject = null;
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        String[] targetNames = new String[]{"server"};
        for (int i = 0; i < selectedRows.size(); ++i) {
            Map oneRow = (Map)selectedRows.get(i);
            String appName = (String)oneRow.get("name");
            progressObject = df.undeploy(df.createTargets(targetNames), appName, (Map)dProps);
            progressObject.waitFor();
            DFDeploymentStatus status = progressObject.getCompletedStatus();
            if (DeployUtil.checkDeployStatus(status, handlerCtx, false)) {
                undeployedAppList.add(appName);
                continue;
            }
            errorList.add(appName);
        }
        DeploymentHandler.removeFromDefaultWebModule(undeployedAppList);
        if (errorList.size() > 0) {
            GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), GuiUtil.getMessage("msg.deploy.UndeployError") + " " + GuiUtil.listToString(errorList, ","));
        }
    }

    private static void removeFromDefaultWebModule(List<String> undeployedAppList) {
        Map vsMap = V3AMX.getInstance().getConfig("server-config").getHttpService().getVirtualServer();
        for (VirtualServer vs : vsMap.values()) {
            String appName = vs.getDefaultWebModule();
            if (GuiUtil.isEmpty(appName)) continue;
            int index = appName.indexOf("#");
            if (index != -1) {
                appName = appName.substring(0, index);
            }
            if (!undeployedAppList.contains(appName)) continue;
            vs.setDefaultWebModule("");
        }
    }

    public static void changeAppStatus(HandlerContext handlerCtx) {
        Map oneRow;
        String appName;
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        System.out.println("===================== changeAppStatus ============= enabled = " + enabled);
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        List selectedRows = obj;
        for (int i = 0; i < selectedRows.size() && DeployUtil.enableApp(appName = (String)(oneRow = (Map)selectedRows.get(i)).get("name"), handlerCtx, enabled); ++i) {
            String msg = GuiUtil.getMessage(enabled ? "msg.enableSuccessfulPE" : "msg.disableSuccessfulPE");
            GuiUtil.prepareAlert(handlerCtx, "success", msg, null);
        }
    }

    public static void getDeploymentDescriptorList(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        ArrayList result = new ArrayList();
        RuntimeRoot runtimeMgr = V3AMX.getInstance().getRuntime();
        List ddList = runtimeMgr.getDeploymentConfigurations(appName);
        if (ddList.size() > 0) {
            for (Map oneDD : ddList) {
                HashMap oneRow = new HashMap();
                oneRow.put("moduleName", oneDD.get("module-name"));
                oneRow.put("ddPath", oneDD.get("dd-path"));
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("descriptors", result);
    }

    public static void getDeploymentDesciptor(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        if (moduleName == null) {
            moduleName = "";
        }
        String descriptorName = (String)handlerCtx.getInputValue("descriptorName");
        RuntimeRoot runtimeMgr = V3AMX.getInstance().getRuntime();
        List ddList = runtimeMgr.getDeploymentConfigurations(appName);
        if (ddList.size() > 0) {
            for (Map oneDD : ddList) {
                if (!((String)oneDD.get("module-name")).equals(moduleName) || !((String)oneDD.get("dd-path")).equals(descriptorName)) continue;
                String content = (String)oneDD.get("dd-content");
                handlerCtx.setOutputValue("content", (Object)content);
                handlerCtx.setOutputValue("encoding", (Object)DeploymentHandler.getEncoding(content));
            }
        }
    }

    protected static String getEncoding(String xmlDoc) {
        String encoding = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlDoc.getBytes()));
            encoding = doc.getXmlEncoding();
        }
        catch (Exception ex) {
            Logger.getLogger(DeploymentHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }
}

