/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.Pool;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.ejb.monitoring.probes.EjbPoolProbeProvider;
import com.sun.ejb.spi.stats.EJBPoolStatsProvider;
import com.sun.enterprise.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPool
implements Pool,
EJBPoolStatsProvider {
    protected static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    protected ArrayList list;
    protected ObjectFactory factory = null;
    protected int waitCount = 0;
    protected int createdCount = 0;
    protected int steadyPoolSize;
    protected int resizeQuantity = 1;
    protected int maxPoolSize = Integer.MAX_VALUE;
    protected long maxWaitTimeInMillis;
    protected int idleTimeoutInSeconds;
    private AbstractPoolTimerTask poolTimerTask;
    protected ClassLoader containerClassLoader;
    protected int destroyedCount = 0;
    protected int poolSuccess = 0;
    protected String poolName;
    protected int poolReturned = 0;
    protected String configData;
    protected EjbPoolProbeProvider poolProbeNotifier;
    protected String appName;
    protected String modName;
    protected String ejbName;
    protected long beanId;

    protected AbstractPool() {
    }

    protected AbstractPool(ObjectFactory factory, long beanId, int steadyPoolSize, int resizeQuantity, int maxPoolsize, long maxWaitTimeInMillis, int idleTimeoutInSeconds, ClassLoader loader) {
        this.initializePool(factory, beanId, steadyPoolSize, resizeQuantity, maxPoolsize, maxWaitTimeInMillis, idleTimeoutInSeconds, loader);
    }

    protected void initializePool(ObjectFactory factory, long beanId, int steadyPoolSize, int resizeQuantity, int maxPoolsize, long maxWaitTimeInMillis, int idleTimeoutInSeconds, ClassLoader loader) {
        this.list = new ArrayList();
        this.factory = factory;
        this.steadyPoolSize = steadyPoolSize;
        this.resizeQuantity = resizeQuantity;
        this.maxPoolSize = maxPoolsize;
        this.maxWaitTimeInMillis = maxWaitTimeInMillis;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
        this.beanId = beanId;
        if (steadyPoolSize > 0) {
            for (int i = 0; i < steadyPoolSize; ++i) {
                this.list.add(factory.create(null));
                this.poolProbeNotifier.ejbObjectAddedEvent(beanId, this.appName, this.modName, this.ejbName);
                ++this.createdCount;
            }
        }
        this.containerClassLoader = loader;
        if (this.idleTimeoutInSeconds > 0) {
            try {
                this.poolTimerTask = new AbstractPoolTimerTask();
                EjbContainerUtilImpl.getInstance().getTimer().scheduleAtFixedRate((TimerTask)this.poolTimerTask, (long)idleTimeoutInSeconds * 1000L, (long)idleTimeoutInSeconds * 1000L);
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[AbstractPool]: Could not add AbstractPoolTimerTask ... Continuing anyway...");
            }
        }
    }

    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    public void setInfo(String appName, String modName, String ejbName) {
        this.appName = appName;
        this.modName = modName;
        this.ejbName = ejbName;
        this.poolProbeNotifier = new EjbPoolProbeProvider();
    }

    public Object getObject(boolean canWait, Object param) throws PoolException {
        return this.getObject(param);
    }

    public Object getObject(long maxWaitTime, Object param) throws PoolException {
        return this.getObject(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object param) throws PoolException {
        long t1 = 0L;
        long totalWaitTime = 0L;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            block13: {
                block14: {
                    do {
                        int size;
                        if ((size = this.list.size()) > 0) {
                            ++this.poolSuccess;
                            return this.list.remove(size - 1);
                        }
                        if (this.createdCount - this.destroyedCount < this.maxPoolSize) {
                            this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                            ++this.createdCount;
                            break block13;
                        }
                        if (this.maxWaitTimeInMillis < 0L) break block14;
                        ++this.waitCount;
                        t1 = System.currentTimeMillis();
                        try {
                            _logger.log(Level.FINE, "[AbstractPool]: Waiting on the pool to get a bean instance...");
                            this.list.wait(this.maxWaitTimeInMillis);
                        }
                        catch (InterruptedException inEx) {
                            throw new PoolException("Thread interrupted.", inEx);
                        }
                        --this.waitCount;
                        totalWaitTime += System.currentTimeMillis() - t1;
                        size = this.list.size();
                        if (size <= 0) continue;
                        ++this.poolSuccess;
                        return this.list.remove(size - 1);
                    } while (this.maxWaitTimeInMillis == 0L || totalWaitTime < this.maxWaitTimeInMillis);
                    throw new PoolException("Pool Instance not obtained within given time interval.");
                }
                throw new PoolException("Pool Instance not obtained within given time interval.");
            }
        }
        try {
            return this.factory.create(param);
        }
        catch (Exception poolEx) {
            ArrayList arrayList2 = this.list;
            synchronized (arrayList2) {
                this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                --this.createdCount;
            }
            throw new RuntimeException("Caught Exception when trying to create pool Object ", poolEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(object);
            ++this.poolReturned;
            if (this.waitCount > 0) {
                this.list.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
            if (this.waitCount > 0) {
                this.list.notify();
            }
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception in destroyObject()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int count) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            for (int i = 0; i < count; ++i) {
                try {
                    this.list.add(this.factory.create(null));
                    this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.createdCount;
                    continue;
                }
                catch (PoolException poolEx) {
                    _logger.log(Level.FINE, "Exception in preload()", poolEx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    _logger.log(Level.WARNING, "[AbstractPool]: Cancelled pool timer task  at: " + new Date());
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            _logger.log(Level.FINE, "[AbstractPool]: Destroying " + this.list.size() + " beans from the pool...");
            ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.containerClassLoader);
            Object[] array = this.list.toArray();
            for (int i = 0; i < array.length; ++i) {
                try {
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(array[i]);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "Exception in destroy()", th);
                    }
                    continue;
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[AbstractPool]: Error while destroying: " + th);
                }
            }
            _logger.log(Level.FINE, "[AbstractPool]: Pool closed....");
            this.list = new ArrayList();
            Utility.setContextClassLoader((ClassLoader)origLoader);
        }
        this.list = null;
        this.factory = null;
        this.poolTimerTask = null;
        this.containerClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int count) {
        ArrayList removeList = new ArrayList();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.list.remove(--size));
                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.destroyedCount;
            }
            this.list.notifyAll();
        }
        for (int i = removeList.size() - 1; i >= 0; --i) {
            this.factory.destroy(removeList.remove(i));
            try {
                this.factory.destroy(removeList.remove(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "Exception in destroy()", th);
            }
        }
    }

    protected abstract void removeIdleObjects();

    public int getCreatedCount() {
        return this.createdCount;
    }

    public int getDestroyedCount() {
        return this.destroyedCount;
    }

    public int getPoolSuccess() {
        return this.poolSuccess;
    }

    public int getSize() {
        return this.list.size();
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public int getResizeQuantity() {
        return this.resizeQuantity;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public void setConfigData(String configData) {
        this.configData = configData;
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("[Pool: ").append("SZ=").append(this.list.size()).append("; ").append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("WC=").append(this.waitCount).append("; ").append("MSG=0");
        if (this.configData != null) {
            sbuf.append(this.configData);
        }
        sbuf.append("]");
    }

    public int getJmsMaxMessagesLoad() {
        return 0;
    }

    public int getNumBeansInPool() {
        return this.list.size();
    }

    public int getNumThreadsWaiting() {
        return this.waitCount;
    }

    public int getTotalBeansCreated() {
        return this.createdCount;
    }

    public int getTotalBeansDestroyed() {
        return this.destroyedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllMonitoredAttrbuteValues() {
        StringBuffer sbuf = new StringBuffer();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            sbuf.append("createdCount=").append(this.createdCount).append(";").append("destroyedCount=").append(this.destroyedCount).append(";").append("waitCount=").append(this.waitCount).append(";").append("size=").append(this.list.size()).append(";");
        }
        sbuf.append("maxPoolSize=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    public String getAllAttrValues() {
        StringBuffer sbuf = new StringBuffer();
        if (null != this.poolName) {
            sbuf.append(":").append(this.poolName);
        } else {
            sbuf.append(":POOL");
        }
        sbuf.append("[FP=").append(this.poolSuccess).append(",").append("TC=").append(this.createdCount).append(",").append("TD=").append(this.destroyedCount).append(",").append("PR=").append(this.poolReturned).append(",").append("TW=").append(this.waitCount).append(",").append("CS=").append(this.list.size()).append(",").append("MS=").append(this.maxPoolSize);
        return sbuf.toString();
    }

    private class AbstractPoolTimerTask
    extends TimerTask {
        Object lock;

        AbstractPoolTimerTask() {
        }

        AbstractPoolTimerTask(Object lock) {
            this.lock = lock;
        }

        public void run() {
            final Thread currentThread = Thread.currentThread();
            final ClassLoader previousClassLoader = currentThread.getContextClassLoader();
            final ClassLoader ctxClassLoader = AbstractPool.this.containerClassLoader;
            try {
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(ctxClassLoader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            currentThread.setContextClassLoader(ctxClassLoader);
                            return null;
                        }
                    });
                }
                try {
                    if (AbstractPool.this.list.size() > AbstractPool.this.steadyPoolSize) {
                        _logger.log(Level.FINE, "[AbstractPool]: Removing idle  objects from pool. Current Size: " + AbstractPool.this.list.size() + "/" + AbstractPool.this.steadyPoolSize + ". Time: " + new Date());
                        AbstractPool.this.removeIdleObjects();
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            currentThread.setContextClassLoader(previousClassLoader);
                            return null;
                        }
                    });
                }
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "Exception in run()", th);
            }
        }
    }
}

