/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.XMLStreamReaderFilter;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public abstract class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    Logger logger;
    @Inject
    protected Habitat habitat;
    @Inject
    ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;

    public void run(ConfigParser parser) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Startup class : " + this.getClass().getName());
        }
        this.habitat.addComponent("parent-class-loader", new ExistingSingletonInhabitant<ClassLoader>(ClassLoader.class, this.registry.getParentClassLoader()));
        try {
            this.parseDomainXml(parser, this.getDomainXml(this.env), this.env.getInstanceName());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse domain.xml", e);
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        this.decorate();
    }

    protected void decorate() {
        Server server = this.habitat.getComponent(Server.class, this.env.getInstanceName());
        this.habitat.addIndex(new ExistingSingletonInhabitant<Server>(server), Server.class.getName(), "default-instance-name");
        this.habitat.addIndex(new ExistingSingletonInhabitant<Config>(this.habitat.getComponent(Config.class, server.getConfigRef())), Config.class.getName(), "default-instance-name");
    }

    protected void upgrade() {
        for (Inhabitant<ConfigurationUpgrade> cu : this.habitat.getInhabitants(ConfigurationUpgrade.class)) {
            try {
                cu.get();
                Logger.getAnonymousLogger().fine("Successful Upgrade domain.xml with " + cu.getClass());
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.FINE, e.toString(), e);
                Logger.getAnonymousLogger().severe(cu.getClass() + " upgrading domain.xml failed " + e);
            }
        }
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        return new File(env.getConfigDirPath(), "domain.xml").toURI().toURL();
    }

    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        try {
            DomainXmlReader xsr = new DomainXmlReader(domainXml, serverName);
            parser.parse(xsr, this.getDomDocument());
            xsr.close();
            if (!xsr.foundConfig) {
                throw new RuntimeException("No <config> seen for name=" + xsr.configName);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to parse " + domainXml, e);
        }
    }

    protected abstract DomDocument getDomDocument();

    private class DomainXmlReader
    extends XMLStreamReaderFilter {
        private String configName;
        private final URL domainXml;
        private final String serverName;
        private boolean foundConfig;
        private InputStream stream;

        public DomainXmlReader(URL domainXml2, String serverName) throws XMLStreamException {
            try {
                this.stream = domainXml2.openStream();
                this.setParent(DomainXml.this.xif.createXMLStreamReader(domainXml2.toExternalForm(), this.stream));
                this.domainXml = domainXml2;
                this.serverName = serverName;
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        public void close() throws XMLStreamException {
            super.close();
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        boolean filterOut() throws XMLStreamException {
            this.checkConfigRef(this.getParent());
            if (this.getLocalName().equals("config")) {
                if (this.configName == null) {
                    this.parse2ndTime();
                    assert (this.configName != null);
                }
                if (this.configName.equals(this.getAttributeValue(null, "name"))) {
                    this.foundConfig = true;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void parse2ndTime() throws XMLStreamException {
            DomainXml.this.logger.info("Forced to parse " + this.domainXml + " twice because we didn't see <server> before <config>");
            try {
                InputStream stream = this.domainXml.openStream();
                XMLStreamReader xsr = DomainXml.this.xif.createXMLStreamReader(this.domainXml.toExternalForm(), stream);
                while (this.configName == null) {
                    switch (xsr.next()) {
                        case 1: {
                            this.checkConfigRef(xsr);
                            break;
                        }
                    }
                }
                xsr.close();
                stream.close();
                if (this.configName == null) {
                    throw new RuntimeException(this.domainXml + " contains no <server> element that matches " + this.serverName);
                }
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to parse " + this.domainXml, e);
            }
        }

        private void checkConfigRef(XMLStreamReader xsr) {
            String ln = xsr.getLocalName();
            if (this.configName == null && ln.equals("server") && this.serverName.equals(xsr.getAttributeValue(null, "name"))) {
                this.configName = xsr.getAttributeValue(null, "config-ref");
                if (this.configName == null) {
                    throw new RuntimeException("<server> element is missing @config-ref at " + this.formatLocation(xsr));
                }
            }
        }

        private String formatLocation(XMLStreamReader xsr) {
            return "line " + xsr.getLocation().getLineNumber() + " at " + xsr.getLocation().getSystemId();
        }
    }
}

