/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RARUtils {
    static Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(RARUtils.class);

    private static Map extractRABeanProps(String raClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Map hMap = new HashMap();
        if (raClassName.trim().length() != 0) {
            Class<?> c = classLoader.loadClass(raClassName);
            if (_logger.isLoggable(Level.FINER)) {
                RARUtils.printClassDetails(c);
            }
            hMap = RARUtils.getJavaBeanProperties(c);
        }
        return hMap;
    }

    private static Map getJavaBeanProperties(Class c) {
        Method[] m = c.getMethods();
        HashMap hMap = new HashMap();
        for (int i = 0; i < m.length; ++i) {
            _logger.finer(m[i].getName());
            if (!m[i].getName().startsWith("get") || !RARUtils.isValidRABeanConfigProperty(m[i].getReturnType())) continue;
            hMap.put(m[i].getName().substring(3), m[i].getReturnType());
        }
        hMap.remove("Class");
        return hMap;
    }

    public static boolean isValidRABeanConfigProperty(Class clz) {
        return clz.isPrimitive() || clz.equals(String.class) || RARUtils.isPrimitiveWrapper(clz);
    }

    private static boolean isPrimitiveWrapper(Class clz) {
        return clz.equals(Boolean.class) || clz.equals(Character.class) || clz.equals(Byte.class) || clz.equals(Short.class) || clz.equals(Integer.class) || clz.equals(Long.class) || clz.equals(Float.class) || clz.equals(Double.class);
    }

    private static void printClassDetails(Class c) {
        Method[] m = c.getMethods();
        _logger.finer("Methods in " + c.getName());
        for (int i = 0; i < m.length; ++i) {
            _logger.finer(m[i].toString());
        }
    }

    public static Set getMergedActivationConfigProperties(EjbMessageBeanDescriptor msgDesc) {
        Set standardProps;
        HashSet<EnvironmentProperty> mergedProps = new HashSet<EnvironmentProperty>();
        HashSet<String> runtimePropNames = new HashSet<String>();
        Set runtimeProps = msgDesc.getRuntimeActivationConfigProperties();
        if (runtimeProps != null) {
            for (EnvironmentProperty entry : runtimeProps) {
                mergedProps.add(entry);
                String propName = entry.getName();
                runtimePropNames.add(propName);
            }
        }
        if ((standardProps = msgDesc.getActivationConfigProperties()) != null) {
            for (EnvironmentProperty entry : standardProps) {
                String propName = entry.getName();
                if (runtimePropNames.contains(propName)) continue;
                mergedProps.add(entry);
            }
        }
        return mergedProps;
    }
}

