/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin.ee;

import java.io.Serializable;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.ForbiddenStateException;
import org.jboss.weld.WeldException;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.builtin.CallableMethodHandler;
import org.jboss.weld.bean.builtin.ee.AbstractEECallable;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEResourceProducerField<X, T>
extends ProducerField<X, T> {
    private final T proxy;

    public static <X, T> EEResourceProducerField<X, T> of(WeldField<T, X> field, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        return new EEResourceProducerField<X, T>(field, declaringBean, manager);
    }

    protected EEResourceProducerField(WeldField<T, X> field, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        super(field, declaringBean, manager);
        try {
            this.proxy = Reflections.isFinal(field.getJavaClass()) || Serializable.class.isAssignableFrom(field.getJavaClass()) ? null : Proxies.createProxy(new CallableMethodHandler(new EEResourceCallable(this.getManager(), this)), Proxies.TypeInfo.of(this.getTypes()).add((Type)((Object)Serializable.class)));
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.checkEEResource();
        }
    }

    protected void checkEEResource() {
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = this.manager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = this.manager.getServices().get(WSApiAbstraction.class);
        if (!this.getAnnotatedItem().isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) && !this.getAnnotatedItem().isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS) && !this.getAnnotatedItem().isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) && !this.getAnnotatedItem().isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || this.getAnnotatedItem().isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS)) {
            throw new ForbiddenStateException(BeanMessage.INVALID_RESOURCE_PRODUCER_FIELD, this.getAnnotatedItem());
        }
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        if (this.proxy == null) {
            return this.createUnderlying(creationalContext);
        }
        return this.proxy;
    }

    private T createUnderlying(CreationalContext<T> creationalContext) {
        return super.create(creationalContext);
    }

    @Override
    public boolean isPassivationCapable() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EEResourceCallable<T>
    extends AbstractEECallable<T> {
        private static final long serialVersionUID = 6287931036073200963L;
        private final String beanId;
        private transient T instance;

        public EEResourceCallable(BeanManagerImpl beanManager, ProducerField<?, T> producerField) {
            super(beanManager);
            this.beanId = producerField.getId();
        }

        @Override
        public T call() throws Exception {
            if (this.instance == null) {
                Object contextual = Container.instance().deploymentServices().get(ContextualStore.class).getContextual(this.beanId);
                if (contextual instanceof EEResourceProducerField) {
                    EEResourceProducerField bean = (EEResourceProducerField)contextual;
                    this.instance = bean.createUnderlying(this.getBeanManager().createCreationalContext((Contextual)bean));
                } else {
                    throw new ForbiddenStateException(BeanMessage.BEAN_NOT_EE_RESOURCE_PRODUCER, contextual);
                }
            }
            return this.instance;
        }

        public String toString() {
            return this.beanId;
        }
    }
}

