/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-javamail-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.javamail.resource")
public class DeleteJavaMailResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJavaMailResource.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    MailResource[] mailResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (!this.isResourceExists(this.resources, this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.mail.resource.notfound", "A Mail resource named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (MailResource resource : DeleteJavaMailResource.this.mailResources) {
                        if (!resource.getJndiName().equals(DeleteJavaMailResource.this.jndiName)) continue;
                        param.getResources().remove(resource);
                        break;
                    }
                    return DeleteJavaMailResource.this.mailResources;
                }
            }, this.resources);
            targetServer.deleteResourceRef(this.jndiName);
            report.setMessage(localStrings.getLocalString("delete.mail.resource.success", "Mail resource {0} deleted", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.mail.resource.failed", "Unable to delete mail resource {0}", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof MailResource) || !((MailResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }
}

