/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Server;
import org.glassfish.deployment.common.ModuleExploder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerImpl
extends EJBContainer {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private final Server server;
    private final EmbeddedEjbContainer ejbContainer;
    private final EmbeddedDeployer deployer;
    private String deployedAppName;
    private Habitat habitat;
    private volatile int state = 0;
    private Cleanup cleanup = null;
    private static final int STARTING = 0;
    private static final int RUNNING = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;

    EJBContainerImpl(Habitat habitat, Server server, EmbeddedEjbContainer ejbContainer, EmbeddedDeployer deployer) {
        this.habitat = habitat;
        this.server = server;
        this.ejbContainer = ejbContainer;
        this.deployer = deployer;
        this.state = 1;
    }

    void deploy(Map<?, ?> properties, Set<File> modules) throws EJBException {
        File app = null;
        try {
            app = this.getOrCreateApplication(modules);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerImpl] Deploying app: " + app);
            }
            DeployCommandParameters dp = new DeployCommandParameters();
            dp.path = app;
            if (properties != null) {
                dp.name = (String)properties.get("javax.ejb.embeddable.appName");
            }
            this.deployedAppName = this.deployer.deploy(app, dp);
            this.cleanup = new Cleanup(this);
        }
        catch (IOException e) {
            throw new EJBException("Failed to deploy EJB modules", e);
        }
        if (this.deployedAppName == null) {
            throw new EJBException("Failed to deploy EJB modules - see log for details");
        }
    }

    @Override
    public Context getContext() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN getContext()");
        }
        try {
            return new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(_logger.getResourceBundle().getString("ejb.embedded.cannot_create_context"), e);
        }
    }

    @Override
    public void close() {
        if (this.cleanup != null) {
            this.cleanup.disable();
        }
        if (this.isOpen()) {
            this.forceClose();
        }
    }

    void forceClose() {
        this.state = 2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN close()");
        }
        this.cleanupTransactions();
        this.cleanupConnectorRuntime();
        this.undeploy();
        this.stop();
    }

    boolean isOpen() {
        return this.state == 1;
    }

    private File getOrCreateApplication(Set<File> modules) throws EJBException, IOException {
        File result = null;
        if (modules == null || modules.size() == 0) {
            _logger.info("[EJBContainerImpl] No modules found");
        } else if (modules.size() == 1) {
            result = modules.iterator().next();
        } else {
            result = File.createTempFile("ejb-app", "");
            if (result.delete() && result.mkdirs()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[EJBContainerImpl] temp dir created at " + result.getAbsolutePath());
                }
            } else {
                throw new EJBException("Not able to create temp dir " + result.getAbsolutePath());
            }
            for (File f : modules) {
                File out;
                int lastpart;
                String filename = f.toURI().getSchemeSpecificPart();
                if (filename.endsWith(File.separator) || filename.endsWith("/")) {
                    int length = filename.length();
                    filename = filename.substring(0, length - 1);
                }
                if ((lastpart = filename.lastIndexOf(File.separatorChar)) == -1) {
                    lastpart = filename.lastIndexOf(47);
                }
                String name = filename.substring(lastpart + 1);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[EJBContainerImpl] Converted file name: " + filename + " to " + name);
                }
                if (f.isDirectory()) {
                    out = new File(result, name + "_jar");
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[EJBContainerImpl] Copying directory to: " + out);
                    }
                    FileUtils.copy((File)f, (File)out);
                    continue;
                }
                out = new File(result, FileUtils.makeFriendlyFilename((String)name));
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[EJBContainerImpl] Exploding jar to: " + out);
                }
                ModuleExploder.explodeJar((File)f, (File)out);
            }
        }
        return result;
    }

    private void cleanupTransactions() {
        try {
            Inhabitant inhabitant = this.habitat.getInhabitantByType(TransactionManager.class);
            if (inhabitant != null && inhabitant.isInstantiated()) {
                TransactionManager txmgr = (TransactionManager)inhabitant.get();
                txmgr.rollback();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error in cleanupTransactions", t);
        }
    }

    private void cleanupConnectorRuntime() {
        try {
            Inhabitant inhabitant = this.habitat.getInhabitantByType(ConnectorRuntime.class);
            if (inhabitant != null && inhabitant.isInstantiated()) {
                ConnectorRuntime connectorRuntime = (ConnectorRuntime)inhabitant.get();
                connectorRuntime.cleanUpResourcesAndShutdownAllActiveRAs();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error in cleanupConnectorRuntime", t);
        }
    }

    private void undeploy() {
        if (this.deployedAppName != null) {
            try {
                this.deployer.undeploy(this.deployedAppName, null);
            }
            catch (Exception e) {
                _logger.warning("Cannot undeploy deployed modules: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        try {
            try {
                this.server.stop();
            }
            catch (LifecycleException e) {
                _logger.warning("Cannot stop embedded container " + e.getMessage());
                Object var3_2 = null;
                this.state = 3;
            }
            Object var3_1 = null;
            this.state = 3;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.state = 3;
            throw throwable;
        }
    }

    private static class Cleanup
    implements Runnable {
        private Thread cleanupThread = null;
        private EJBContainerImpl container = null;

        Cleanup(EJBContainerImpl container) {
            this.container = container;
            this.cleanupThread = new Thread((Runnable)this, "EJBContainerImplCleanup");
            Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        }

        void disable() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime.getRuntime().removeShutdownHook(Cleanup.this.cleanupThread);
                    return null;
                }
            });
        }

        public void run() {
            if (this.container.isOpen()) {
                this.container.forceClose();
            }
        }
    }
}

